% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{gg_tsresiduals}
\alias{gg_tsresiduals}
\title{Ensemble of time series residual diagnostic plots}
\usage{
gg_tsresiduals(data, type = "innovation", plot_type = "histogram", ...)
}
\arguments{
\item{data}{A mable containing one model with residuals.}

\item{type}{The type of residuals to compute. If \code{type="response"}, residuals on the back-transformed data will be computed.}

\item{plot_type}{type of plot to include in lower right corner. By default
(\code{"auto"}) a season plot will be shown for seasonal data, a spectrum plot
will be shown for non-seasonal data without missing values, and a PACF will
be shown otherwise.}

\item{...}{Additional arguments passed to \code{\link[=gg_tsdisplay]{gg_tsdisplay()}}.}
}
\value{
A list of ggplot objects showing a useful plots of a time series model's residuals.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\details{
\code{gg_tsresiduals()} was soft deprecated in feasts 0.4.2. Please use \code{ggtime::gg_tsresiduals()} instead.

Plots the residuals using a time series plot, ACF and histogram.
}
\examples{
if (requireNamespace("fable", quietly = TRUE)) {
library(fable)

tsibbledata::aus_production \%>\%
  model(ETS(Beer)) \%>\%
  gg_tsresiduals()
}

}
\references{
Hyndman and Athanasopoulos (2019) \emph{Forecasting: principles
and practice}, 3rd edition, OTexts: Melbourne, Australia.
\url{https://OTexts.com/fpp3/}
}
\seealso{
\code{\link[=gg_tsdisplay]{gg_tsdisplay()}}
}
