% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_regression_helper_functions.R
\name{compute_pred}
\alias{compute_pred}
\title{Compute Predictions from Fuzzy Linear Model}
\usage{
compute_pred(object, X_fuzzy)
}
\arguments{
\item{object}{List. Result of fuzzy least squares regression containing \code{beta_hat}.}

\item{X_fuzzy}{List. Fuzzified predictor variables.}
}
\value{
A list of fuzzy predictions.
}
\description{
Compute Predictions from Fuzzy Linear Model
}
\examples{
# Example setup
X_fuzzy <- list(
  list(list(l = 1, x = 2, r = 3), list(l = 4, x = 5, r = 6)),
  list(list(l = 2, x = 3, r = 4), list(l = 5, x = 6, r = 7))
)
beta_hat <- c(0.5, 1.2, -0.8)  # Example regression coefficients
object <- list(beta_hat = beta_hat)

# Compute predictions
predictions <- compute_pred(object, X_fuzzy)
print(head(predictions, 6))
}
