% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afni_restricted.R
\name{afni_restricted_plan}
\alias{afni_restricted_plan}
\title{Build an AFNI-style restricted AR plan from root parameters}
\usage{
afni_restricted_plan(
  resid,
  runs = NULL,
  parcels = NULL,
  p = 3L,
  roots,
  estimate_ma1 = TRUE,
  exact_first = TRUE
)
}
\arguments{
\item{resid}{(n x v) residual matrix (used only if estimate_ma1=TRUE)}

\item{runs}{integer vector length n (optional)}

\item{parcels}{integer vector length v (optional; if provided, plan pooling='parcel')}

\item{p}{either 3 or 5}

\item{roots}{either a single list with elements named as needed
- for p=3: list(a, r1, t1, vrt = 1.0)
- for p=5: list(a, r1, t1, r2, t2, vrt = 1.0)
or a named list of such lists keyed by parcel id (character) for per-parcel specs.}

\item{estimate_ma1}{logical, if TRUE estimate MA(1) on AR residuals to mimic AFNI's additive white}

\item{exact_first}{apply exact AR(1) scaling at segment starts (harmless here; default TRUE)}
}
\value{
An \code{fmriAR_plan} with \code{method = "afni"} that can be supplied to
\code{\link[=whiten_apply]{whiten_apply()}}.
}
\description{
Build an AFNI-style restricted AR plan from root parameters
}
\examples{
NULL
}
