% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_functions.R
\name{comp_bayes_lm}
\alias{comp_bayes_lm}
\title{Fit Bayesian competition model}
\source{
Closed-form solutions of Bayesian linear
regression \doi{10.1371/journal.pone.0229930.s004}
}
\usage{
comp_bayes_lm(focal_vs_comp, prior_param = NULL, run_shuffle = FALSE)
}
\arguments{
\item{focal_vs_comp}{data frame from \code{\link[=create_focal_vs_comp]{create_focal_vs_comp()}}}

\item{prior_param}{A list of \verb{\{a_0, b_0, mu_0, V_0\}} prior hyperparameters.
Defaults to \code{a_0 = 250}, \code{b_0 = 250}, \code{mu_0} a vector of zeros of
length \eqn{p + 1}, \code{V_0} an identity matrix of dimension \eqn{(p + 1) x (p
  + 1)}}

\item{run_shuffle}{boolean as to whether to run permutation test shuffle of
competitor tree species within a particular focal_ID}
}
\value{
A list of \verb{\{a_star, b_star, mu_star, V_star\}} posterior hyperparameters
}
\description{
Fit a Bayesian linear regression model with interactions terms where \deqn{y = X \beta + \epsilon}
\tabular{ll}{
\eqn{\mu} \tab mean hyperparameter vector for \eqn{\beta} of length \eqn{p + 1} \cr
\eqn{V} \tab covariance hyperparameter matrix for \eqn{\beta} of dimension \eqn{(p + 1) x (p + 1)} \cr
\eqn{a} \tab shape hyperparameter for \eqn{\sigma^2 > 0} \cr
\eqn{b} \tab scale hyperparameter for \eqn{\sigma^2 > 0}\cr
}
}
\examples{
library(dplyr)

# Load in focal versus comp
data(focal_vs_comp_ex)

comp_bayes_lm_ex <- focal_vs_comp_ex \%>\%
  comp_bayes_lm(prior_param = NULL, run_shuffle = FALSE)
}
\seealso{
Other modeling functions: 
\code{\link{create_bayes_lm_data}()},
\code{\link{predict.comp_bayes_lm}()},
\code{\link{run_cv}()}
}
\concept{modeling functions}
