% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database_inventory.R
\name{database_inventory}
\alias{database_inventory}
\title{Obtain species details for a floristic quality database}
\usage{
database_inventory(database)
}
\arguments{
\item{database}{A database downloaded from
\href{https://universalfqa.org/}{universalfqa.org} either manually or using
\code{\link[=download_database]{download_database()}}.}
}
\value{
A data frame with 9 columns:
\itemize{
   \item scientific_name (character)
   \item family (character)
   \item acronym (character)
   \item nativity (character)
   \item c (numeric)
   \item w (numeric)
   \item physiognomy (character)
   \item duration (character)
   \item common_name (character)
}
}
\description{
\code{database_inventory()} returns a data frame of all plant species
included in a floristic quality database obtained from
\href{https://universalfqa.org/}{universalfqa.org}.
}
\examples{
# While database_glance can be used with a .csv file downloaded
# manually from the universal FQA website, it is most typically used
# in combination with download_database().

chicago_db <- download_database(database_id = 1)
chicago_species <- database_inventory(chicago_db)

}
