% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{identifyDriver}
\alias{identifyDriver}
\title{Identify the GDAL driver that can open a dataset}
\usage{
identifyDriver(
  filename,
  raster = TRUE,
  vector = TRUE,
  allowed_drivers = NULL,
  file_list = NULL
)
}
\arguments{
\item{filename}{Character string containing the name of the file to access.
This may not refer to a physical file, but instead contain information for
the driver on how to access a dataset (e.g., connection string, URL, etc.)}

\item{raster}{Logical value indicating whether to include raster format
drivers in the search, \code{TRUE} by default. May be set to \code{FALSE} to include
only vector drivers.}

\item{vector}{Logical value indicating whether to include vector format
drivers in the search, \code{TRUE} by default. May be set to \code{FALSE} to include
only raster drivers.}

\item{allowed_drivers}{Optional character vector of driver short names
that must be considered. Set to \code{NULL} to consider all candidate drivers
(the default).}

\item{file_list}{Optional character vector of filenames, including those
that are auxiliary to the main filename (see Note). May contain the input
\code{filename} but this is not required. Defaults to \code{NULL}.}
}
\value{
A character string with the short name of the first driver that
successfully identifies the input file name, or \code{NULL} on failure.
}
\description{
\code{identifyDriver()} will try to identify the driver that can open the passed
file name by invoking the Identify method of each registered GDALDriver in
turn. The short name of the first driver that successfully identifies the
file name will be returned as a character string. If all drivers fail then
\code{NULL} is returned.
Wrapper of \code{GDALIdentifyDriverEx()} in the GDAL C API.
}
\note{
In order to reduce the need for such searches to touch the file system
machinery of the operating system, it is possible to give an optional list
of files. This is the list of all files at the same level in the file
system as the target file, including the target file. The filenames should
not include any path components. If the target object does not have
filesystem semantics then the file list should be \code{NULL}.

At least one of the \code{raster} or \code{vector} arguments must be \code{TRUE}.
}
\examples{
src <- system.file("extdata/ynp_fires_1984_2022.gpkg", package="gdalraster")

identifyDriver(src) |> gdal_formats()
}
\seealso{
\code{\link[=gdal_formats]{gdal_formats()}}
}
