% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSServiceManager.R
\docType{class}
\name{GSServiceManager}
\alias{GSServiceManager}
\title{Geoserver REST API Service Manager}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} with methods for managing GeoServer services
}
\description{
Geoserver REST API Service Manager

Geoserver REST API Service Manager
}
\examples{
\dontrun{
   GSServiceManager$new("http://localhost:8080/geoserver", "admin", "geoserver")
 }

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\keyword{service}
\section{Super class}{
\code{\link[geosapi:GSManager]{geosapi::GSManager}} -> \code{GSServiceManager}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSServiceManager-getServiceSettings}{\code{GSServiceManager$getServiceSettings()}}
\item \href{#method-GSServiceManager-getWmsSettings}{\code{GSServiceManager$getWmsSettings()}}
\item \href{#method-GSServiceManager-getWfsSettings}{\code{GSServiceManager$getWfsSettings()}}
\item \href{#method-GSServiceManager-getWcsSettings}{\code{GSServiceManager$getWcsSettings()}}
\item \href{#method-GSServiceManager-updateServiceSettings}{\code{GSServiceManager$updateServiceSettings()}}
\item \href{#method-GSServiceManager-deleteServiceSettings}{\code{GSServiceManager$deleteServiceSettings()}}
\item \href{#method-GSServiceManager-updateWmsSettings}{\code{GSServiceManager$updateWmsSettings()}}
\item \href{#method-GSServiceManager-updateWfsSettings}{\code{GSServiceManager$updateWfsSettings()}}
\item \href{#method-GSServiceManager-updateWcsSettings}{\code{GSServiceManager$updateWcsSettings()}}
\item \href{#method-GSServiceManager-enableWMS}{\code{GSServiceManager$enableWMS()}}
\item \href{#method-GSServiceManager-enableWFS}{\code{GSServiceManager$enableWFS()}}
\item \href{#method-GSServiceManager-enableWCS}{\code{GSServiceManager$enableWCS()}}
\item \href{#method-GSServiceManager-disableServiceSettings}{\code{GSServiceManager$disableServiceSettings()}}
\item \href{#method-GSServiceManager-disableWMS}{\code{GSServiceManager$disableWMS()}}
\item \href{#method-GSServiceManager-disableWFS}{\code{GSServiceManager$disableWFS()}}
\item \href{#method-GSServiceManager-disableWCS}{\code{GSServiceManager$disableWCS()}}
\item \href{#method-GSServiceManager-clone}{\code{GSServiceManager$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="ERROR"><a href='../../geosapi/html/GSManager.html#method-GSManager-ERROR'><code>geosapi::GSManager$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="INFO"><a href='../../geosapi/html/GSManager.html#method-GSManager-INFO'><code>geosapi::GSManager$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="WARN"><a href='../../geosapi/html/GSManager.html#method-GSManager-WARN'><code>geosapi::GSManager$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="connect"><a href='../../geosapi/html/GSManager.html#method-GSManager-connect'><code>geosapi::GSManager$connect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getClassName"><a href='../../geosapi/html/GSManager.html#method-GSManager-getClassName'><code>geosapi::GSManager$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getCoverageStoreManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getCoverageStoreManager'><code>geosapi::GSManager$getCoverageStoreManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getDataStoreManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getDataStoreManager'><code>geosapi::GSManager$getDataStoreManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getNamespaceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getNamespaceManager'><code>geosapi::GSManager$getNamespaceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getServiceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getServiceManager'><code>geosapi::GSManager$getServiceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getStyleManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getStyleManager'><code>geosapi::GSManager$getStyleManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getSystemStatus"><a href='../../geosapi/html/GSManager.html#method-GSManager-getSystemStatus'><code>geosapi::GSManager$getSystemStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getUrl"><a href='../../geosapi/html/GSManager.html#method-GSManager-getUrl'><code>geosapi::GSManager$getUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getWorkspaceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getWorkspaceManager'><code>geosapi::GSManager$getWorkspaceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="initialize"><a href='../../geosapi/html/GSManager.html#method-GSManager-initialize'><code>geosapi::GSManager$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="logger"><a href='../../geosapi/html/GSManager.html#method-GSManager-logger'><code>geosapi::GSManager$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="monitor"><a href='../../geosapi/html/GSManager.html#method-GSManager-monitor'><code>geosapi::GSManager$monitor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="reload"><a href='../../geosapi/html/GSManager.html#method-GSManager-reload'><code>geosapi::GSManager$reload()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-getServiceSettings"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-getServiceSettings}{}}}
\subsection{Method \code{getServiceSettings()}}{
Get the service settings. To get the service settings for a specific workspace,
   specify the workspace name as \code{ws} parameter, otherwise global settings are
   retrieved.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$getServiceSettings(service, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{service}}{service}

\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{GSServiceSettings}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-getWmsSettings"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-getWmsSettings}{}}}
\subsection{Method \code{getWmsSettings()}}{
Get WMS settings. To get the WMS settings for a specific workspace,
   specify the workspace name as \code{ws} parameter, otherwise global settings are
   retrieved.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$getWmsSettings(ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{GSServiceSettings}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-getWfsSettings"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-getWfsSettings}{}}}
\subsection{Method \code{getWfsSettings()}}{
Get WFS settings. To get the WFS settings for a specific workspace,
   specify the workspace name as \code{ws} parameter, otherwise global settings are
   retrieved.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$getWfsSettings(ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{GSServiceSettings}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-getWcsSettings"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-getWcsSettings}{}}}
\subsection{Method \code{getWcsSettings()}}{
Get WCS settings. To get the WCS settings for a specific workspace,
   specify the workspace name as \code{ws} parameter, otherwise global settings are
   retrieved.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$getWcsSettings(ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{GSServiceSettings}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-updateServiceSettings"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-updateServiceSettings}{}}}
\subsection{Method \code{updateServiceSettings()}}{
Updates the service settings with an object of class \code{GSServiceSettings}.
   An optional workspace name \code{ws} can be specified to update service settings
   applying to a workspace.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$updateServiceSettings(serviceSettings, service, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{serviceSettings}}{serviceSettings object of class \link{GSServiceSettings}}

\item{\code{service}}{service}

\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if updated, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-deleteServiceSettings"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-deleteServiceSettings}{}}}
\subsection{Method \code{deleteServiceSettings()}}{
Deletes the service settings. This method is used internally by \pkg{geosapi} 
   for disabling a service setting at workspace level.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$deleteServiceSettings(service, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{service}}{service}

\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-updateWmsSettings"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-updateWmsSettings}{}}}
\subsection{Method \code{updateWmsSettings()}}{
Updates the WMS settings with an object of class \code{GSServiceSettings}.
   An optional workspace name \code{ws} can be specified to update WMS settings
   applying to a workspace.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$updateWmsSettings(serviceSettings, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{serviceSettings}}{service settings object of class \link{GSServiceSettings}}

\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-updateWfsSettings"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-updateWfsSettings}{}}}
\subsection{Method \code{updateWfsSettings()}}{
Updates the WFS settings with an object of class \code{GSServiceSettings}.
   An optional workspace name \code{ws} can be specified to update WFS settings
   applying to a workspace.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$updateWfsSettings(serviceSettings, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{serviceSettings}}{service settings object of class \link{GSServiceSettings}}

\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-updateWcsSettings"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-updateWcsSettings}{}}}
\subsection{Method \code{updateWcsSettings()}}{
Updates the WCS settings with an object of class \code{GSServiceSettings}.
   An optional workspace name \code{ws} can be specified to update WCS settings
   applying to a workspace.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$updateWcsSettings(serviceSettings, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{serviceSettings}}{service settings object of class \link{GSServiceSettings}}

\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-enableWMS"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-enableWMS}{}}}
\subsection{Method \code{enableWMS()}}{
Enables WMS service settings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$enableWMS(ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if enabled, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-enableWFS"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-enableWFS}{}}}
\subsection{Method \code{enableWFS()}}{
Enables WFS service settings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$enableWFS(ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if enabled, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-enableWCS"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-enableWCS}{}}}
\subsection{Method \code{enableWCS()}}{
Enables WCS service settings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$enableWCS(ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if enabled, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-disableServiceSettings"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-disableServiceSettings}{}}}
\subsection{Method \code{disableServiceSettings()}}{
Disables service settings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$disableServiceSettings(service, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{service}}{service}

\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if disabled, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-disableWMS"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-disableWMS}{}}}
\subsection{Method \code{disableWMS()}}{
Disables WMS service settings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$disableWMS(ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if disabled, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-disableWFS"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-disableWFS}{}}}
\subsection{Method \code{disableWFS()}}{
Disables WFS service settings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$disableWFS(ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if disabled, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-disableWCS"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-disableWCS}{}}}
\subsection{Method \code{disableWCS()}}{
Disables WCS service settings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$disableWCS(ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if disabled, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
