% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-alignpatches.R
\name{alignpatches}
\alias{alignpatches}
\alias{align_plots}
\title{Arrange multiple plots into a grid}
\usage{
alignpatches(
  ...,
  ncol = NULL,
  nrow = NULL,
  byrow = TRUE,
  widths = NA,
  heights = NA,
  area = NULL,
  guides = waiver(),
  theme = NULL,
  design = NULL
)

align_plots(
  ...,
  ncol = NULL,
  nrow = NULL,
  byrow = TRUE,
  widths = NA,
  heights = NA,
  area = NULL,
  guides = waiver(),
  theme = NULL,
  design = NULL
)
}
\arguments{
\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> A list of plots, ususally the
ggplot object. Use \code{NULL} to indicate an empty spacer. Each input must
implement the \code{\link[=patch]{patch()}} method.}

\item{ncol, nrow}{The number of columns and rows in the grid. Defaults to
\code{NULL}. If both are \code{NULL}, the layout dimensions are determined
automatically using the same logic as \code{\link[ggplot2:facet_wrap]{facet_wrap()}}.}

\item{byrow}{A logical value indicating whether plots should be filled in
row-major order (\code{TRUE}) or column-major order (\code{FALSE}). Defaults to
\code{TRUE}.}

\item{widths, heights}{The relative widths and heights of each column and row
in the grid. These values are recycled to match the grid dimensions.  The
special value \code{NA} is treated as a unit of \verb{1null}, unless a fixed-aspect
plot is included — in that case, the affected dimension will expand or
contract to maintain the aspect ratio of the plot. Defaults to \code{NA}.}

\item{area}{A specification of the area layout. Can be defined either as a
character string or as a combination of calls to \code{\link[=area]{area()}}. Defaults to
\code{NULL}.}

\item{guides}{A string with one or more of \code{"t"}, \code{"l"}, \code{"b"}, \code{"r"}, and \code{"i"}
indicating which side of guide legends should be collected. Defaults to
\code{\link[ggplot2:waiver]{waiver()}}, which inherits from the parent layout. If
there is no parent layout, or if \code{NULL} is provided, no guides will be
collected.}

\item{theme}{A \code{\link[ggplot2:theme]{theme()}} object used to customize various
elements of the layout. By default, the theme will inherit from the parent
\code{layout}.}

\item{design}{An alias for \code{area}, retained for backward compatibility.}
}
\value{
An \code{alignpatches} object.
}
\description{
An internal S7 class that represents a collection of aligned plots
along with their layout configuration, titles, tags, and theme.
}
\section{Properties}{

\itemize{
\item \strong{plots}: A list of plot objects.
\item \strong{layout}: A list specifying layout options, including:
\itemize{
\item \code{ncol}, \code{nrow}, \code{byrow}: grid layout parameters.
\item \code{widths}, \code{heights}: relative dimensions of rows/columns.
\item \code{area}: custom area specification.
\item \code{guides}: guide handling.
}
\item \strong{titles}: A list specifying title options (\code{title}, \code{subtitle},
\code{caption}).
\item \strong{tags}: A list specifying tag options (\code{tags}, \code{sep}, \code{prefix},
\code{suffix}).
\item \strong{theme}: A theme configuration object.
}
}

\examples{
# directly copied from patchwork
p1 <- ggplot(mtcars) +
    geom_point(aes(mpg, disp))
p2 <- ggplot(mtcars) +
    geom_boxplot(aes(gear, disp, group = gear))
p3 <- ggplot(mtcars) +
    geom_bar(aes(gear)) +
    facet_wrap(~cyl)
p4 <- ggplot(mtcars) +
    geom_bar(aes(carb))
p5 <- ggplot(mtcars) +
    geom_violin(aes(cyl, mpg, group = cyl))

# Either add the plots as single arguments
align_plots(p1, p2, p3, p4, p5)

# Or use bang-bang-bang to add a list
align_plots(!!!list(p1, p2, p3), p4, p5)

# Match plots to areas by name
area <- "#BB
          AA#"
align_plots(B = p1, A = p2, area = area)

# Compare to not using named plot arguments
align_plots(p1, p2, area = area)

}
\seealso{
\itemize{
\item \code{\link[=layout_design]{layout_design()}}
\item \code{\link[=layout_title]{layout_title()}}
\item \code{\link[=layout_theme]{layout_theme()}}
\item \code{\link[=layout_tags]{layout_tags()}}
}
}
