% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-brain.R
\name{reposition_brain}
\alias{reposition_brain}
\title{Reposition brain slices}
\usage{
reposition_brain(data, position = "horizontal")
}
\arguments{
\item{data}{sf-data.frame of joined brain atlas and data}

\item{position}{position formula for slices}
}
\value{
sf-data.frame with repositioned slices
}
\description{
Function for repositioning
pre-joined atlas data (i.e. data and atlas
already joined to a single data frame).
This makes it possible for users to
reposition the geometry data for the atlas
for control over final plot layout. For even
more detailed control over the positioning,
the "hemi" and "side" columns should be
converted into factors and ordered by wanted
order of appearance.
}
\examples{
reposition_brain(dk, hemi ~ side)
reposition_brain(dk, side ~ hemi)
reposition_brain(dk, hemi + side ~ .)
reposition_brain(dk, . ~ hemi + side)
}
