% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-filter-spct.R
\name{Afr_label}
\alias{Afr_label}
\alias{Rfr_total_label}
\title{Absorptance axis labels}
\usage{
Afr_label(
  unit.exponent = ifelse(pc.out, -2, 0),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels(append = ifelse(axis.symbols, ",", ""))[["s.Afr"]],
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  pc.out = getOption("ggspectra.pc.out", default = FALSE)
)

Rfr_total_label(
  unit.exponent = ifelse(pc.out, -2, 0),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = NULL,
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  pc.out = getOption("ggspectra.pc.out", default = FALSE)
)
}
\arguments{
\item{unit.exponent}{integer}

\item{format}{character string, "R", "R.expresion", "R.character", or
"LaTeX".}

\item{label.text}{character Textual portion of the labels.}

\item{scaled}{logical If \code{TRUE} relative units are assumed.}

\item{normalized}{logical (\code{FALSE}) or numeric Normalization wavelength
in manometers (nm).}

\item{axis.symbols}{logical If \code{TRUE} symbols of the quantities are
added to the \code{name}. Supported only by \code{format = "R.expression"}.}

\item{pc.out}{logical, if TRUE use percent as default instead of fraction
of one.}
}
\value{
a character string or an R expression.
}
\description{
Generate cps axis labels in SI units,
using SI scale factors. Output can be selected as character, expression (R
default devices) or LaTeX (for tikz device).
}
\examples{

Afr_label()
Afr_label(format = "R.expression", axis.symbols = FALSE)
Afr_label(-2)
Afr_label(-3)
Afr_label(format = "R.expression")
Afr_label(format = "LaTeX")
Afr_label(-2, format = "LaTeX")


Rfr_total_label()
Rfr_total_label(axis.symbols = FALSE)
Rfr_total_label(-2)
Rfr_total_label(-3)
Rfr_total_label(format = "R.expression")
Rfr_total_label(format = "LaTeX")
Rfr_total_label(-3, format = "LaTeX")

}
