% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmTMB.R
\name{summary.glmmTMB}
\alias{summary.glmmTMB}
\title{summary for glmmTMB fits}
\usage{
\method{summary}{glmmTMB}(
  object,
  sandwich = FALSE,
  ddf = c("asymptotic", "kenward-roger", "satterthwaite"),
  cluster = getGroups(object),
  ...
)
}
\arguments{
\item{object}{a fitted \code{glmmTMB} object}

\item{sandwich}{use the sandwich estimator for the variance-covariance matrix? (this only works for ML fits, but not for REML fits)}

\item{ddf}{denominator degrees-of-freedom calculation. Default "asymptotic" gives standard Z-statistics
(i.e., 'infinite' denominator df); \code{"kenward-roger"} uses the Kenward-Roger approximation, which will
be ignored for non-REML fits and is entirely untested for GLMMs (see \code{\link{dof_KR}});
\code{"satterthwaite"} uses a Satterthwaite approximation}

\item{cluster}{grouping factor for the sandwich estimator, only used if \code{sandwich==TRUE}.}

\item{...}{unused, for method compatibility}
}
\description{
summary for glmmTMB fits
}
