% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-grafos-TSP.R
\encoding{UTF-8}
\name{compute_p_distance}
\alias{compute_p_distance}
\title{Distance-p between two-dimensional points}
\usage{
compute_p_distance(x, y, p = 2)
}
\arguments{
\item{x}{A two-dimensional point}

\item{y}{A two-dimensional point}

\item{p}{The \eqn{p}-parameter of the distance-\eqn{p}}
}
\value{
The distance-\eqn{p} between points \eqn{x} and \eqn{y}.
}
\description{
It computes the distance-\eqn{p} between two-dimensional points.
}
\details{
The distance-\eqn{p} is defined by \deqn{d_p(x,y) = \left(\sum_i
    (x_i-y_i)^p\right)^{\frac{1}{p}}}.
}
\examples{
compute_p_distance(c(1,2),c(3,4))      # 2.8284
compute_p_distance(c(1,2),c(3,4),p=1)  # 4

}
\seealso{
\link{compute_distance_matrix} computes the distance matrix of
a set of two-dimensional points, \link{compute_tour_distance}
computes tour distances.
}
\author{
Cesar Asensio
}
