% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pkgs_info.R
\name{get_pkgs_info}
\alias{get_pkgs_info}
\title{Get information about packages used in a project}
\usage{
get_pkgs_info(
  pkgs = "All",
  out.dir = NULL,
  omit = c("grateful"),
  cite.tidyverse = TRUE,
  dependencies = FALSE,
  bib.file = "grateful-refs",
  include.RStudio = FALSE,
  desc.path = NULL,
  skip.missing = FALSE,
  ...
)
}
\arguments{
\item{pkgs}{Character. Either "All" to include all packages used in scripts
within the project/folder (the default), "Session" to include only packages
used in the current session, or the path to an R script (including \code{.R} extension),
'Rmarkdown' (\code{.Rmd}) or 'Quarto' document (\code{qmd}) to scan only the packages used
in that single script or document.
Alternatively, \code{pkgs} can also be a character vector of package names to
get citations for. To cite R as well as the given packages,
include "base" in \code{pkgs} (see examples).
Finally, \code{pkgs} can be a character vector of \code{Depends}, \code{Imports}, \code{Suggests},
\code{LinkingTo} and their combination, to obtain the dependencies of an R package
as stated in its DESCRIPTION file (see \code{desc.path}).
Note that in this case, package versions will
be 'NA' unless required versions are stated in the DESCRIPTION file
(e.g. 'testthat (>= 3.0.0)'), and package citations will use the information
from installed versions of those packages in the user computer.}

\item{out.dir}{Directory to save the BibTeX file with references.
It is recommended to set \code{out.dir = getwd()}.}

\item{omit}{Character vector of package names to be omitted from the citation
report. \code{grateful} is omitted by default. Use \code{omit = NULL} to include all
packages.}

\item{cite.tidyverse}{Logical. If \code{TRUE}, all tidyverse packages
(dplyr, ggplot2, etc) will be collapsed into a single citation
of the 'tidyverse', as recommended by the tidyverse team.}

\item{dependencies}{Logical. Include the dependencies of your used packages?
If \code{TRUE}, will include all the packages that your used packages depend on.}

\item{bib.file}{Desired name for the BibTeX file containing packages references
("grateful-refs" by default).}

\item{include.RStudio}{Logical. If \code{TRUE}, adds a citation for the
current version of RStudio.}

\item{desc.path}{Optional. Path to the package DESCRIPTION file from which to
parse the package dependencies (see \code{pkgs}).
If NULL, will default to the working directory.}

\item{skip.missing}{Logical. If FALSE (the default), will return an error if
some package(s) are used somewhere in the project but they are not currently
installed. If TRUE, will skip those missing packages, issuing a warning. Note
such packages will thus not be included in the citation list, even though they
might have been used in the project.}

\item{...}{Other parameters passed to \code{\link[renv:dependencies]{renv::dependencies()}}.}
}
\value{
A data.frame with package info,
and a file containing package references in BibTeX format.
}
\description{
This function scans the project for R packages used, saves a BibTeX file with
package references, and returns a data frame with package names, version,
and citation keys.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_pkgs_info(out.dir = tempdir())
get_pkgs_info(pkgs = c("renv", "remotes"), out.dir = tempdir())
\dontshow{\}) # examplesIf}
}
