% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utililties.R
\name{is_factor_term}
\alias{is_factor_term}
\alias{is_factor_term.terms}
\alias{is_factor_term.gam}
\alias{is_factor_term.bam}
\alias{is_factor_term.gamm}
\alias{is_factor_term.list}
\title{Is a model term a factor (categorical)?}
\usage{
is_factor_term(object, term, ...)

\method{is_factor_term}{terms}(object, term, ...)

\method{is_factor_term}{gam}(object, term, ...)

\method{is_factor_term}{bam}(object, term, ...)

\method{is_factor_term}{gamm}(object, term, ...)

\method{is_factor_term}{list}(object, term, ...)
}
\arguments{
\item{object}{an R object on which method dispatch is performed}

\item{term}{character; the name of a model term, in the sense of
\code{attr(terms(object), "term.labels")}. Currently not checked to see if the
term exists in the model.}

\item{...}{arguments passed to other methods.}
}
\value{
A logical: \code{TRUE} if and only if all variables involved in the term
are factors, otherwise \code{FALSE}.
}
\description{
Given the name (a term label) of a term in a model, identify if the term is a
factor term or numeric. This is useful when considering interactions, where
terms like \code{fac1:fac2} or \code{num1:fac1} may be requested by the user. Only for
terms of the type \code{fac1:fac2} will this function return \code{TRUE}.
}
