% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{films}
\alias{films}
\title{Feature films in competition at the Cannes Film Festival}
\format{
A tibble with 1,873 rows and 8 variables:
\describe{
\item{year}{The year of the festival in which the film was in competition.}
\item{title,original_title}{The \code{title} field provides the film title used
for English-speaking audiences. The \code{original_title} field is populated when
\code{title} differs greatly from the non-English original.}
\item{director}{The director or set of co-directors for the film. Multiple
directors are separated by a comma.}
\item{languages}{The languages spoken in the film in the order of appearance.
This consists of ISO 639 language codes (primarily as two-letter codes, but
using three-letter codes where necessary).}
\item{countries_of_origin}{The country or countries of origin for the
production. Here, 2-letter ISO 3166-1 country codes (set in uppercase) are
used.}
\item{run_time}{The run time of the film in hours and minutes. This is given
as a string in the format \verb{[x]h [y]m}.}
\item{imdb_url}{The URL of the film's information page in the Internet Movie
Database (IMDB).}
}
}
\usage{
films
}
\description{
Each entry in the \code{films} is a feature film that appeared in the official
selection during a festival year (starting in 1946 and active to the present
day). The \code{year} column refers to the year of the festival and this figure
doesn't always coincide with the release year of the film. The film's title
reflects the most common title of the film in English, where the
\code{original_title} column provides the title of the film in its spoken language
(transliterated to Roman script where necessary).
}
\section{Dataset ID and Badge}{

DATA-9

\if{html}{\out{
<div style="text-align:center;"><img src="https://raw.githubusercontent.com/rstudio/gt/master/images/dataset_films.png" alt="This image of that of a dataset badge." style="width:50\%;padding-bottom:20px;"></div>
}}
}

\section{Dataset Introduced}{

\code{v0.11.0} (July 9, 2024)
}

\examples{
dplyr::glimpse(films)
}
\seealso{
Other datasets: 
\code{\link{constants}},
\code{\link{countrypops}},
\code{\link{exibble}},
\code{\link{gibraltar}},
\code{\link{gtcars}},
\code{\link{illness}},
\code{\link{metro}},
\code{\link{nuclides}},
\code{\link{peeps}},
\code{\link{photolysis}},
\code{\link{pizzaplace}},
\code{\link{reactions}},
\code{\link{rx_addv}},
\code{\link{rx_adsl}},
\code{\link{sp500}},
\code{\link{sza}},
\code{\link{towny}}
}
\concept{datasets}
\keyword{datasets}
