% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_clustered_median_junction_expression.R
\name{get_clustered_median_junction_expression}
\alias{get_clustered_median_junction_expression}
\title{Get Clustered Median Junction Expression}
\usage{
get_clustered_median_junction_expression(
  gencodeIds,
  datasetId = "gtex_v8",
  tissueSiteDetailIds = NULL,
  .return_raw = FALSE
)
}
\arguments{
\item{gencodeIds}{A character vector of Versioned GENCODE IDs, e.g.
c("ENSG00000132693.12", "ENSG00000203782.5").}

\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{tissueSiteDetailIds}{Character vector of IDs for tissues of interest.
Can be GTEx specific IDs (e.g. "Whole_Blood"; use
\code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}} to see valid values) or Ontology IDs.}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
Find median junction expression data along with hierarchical
clusters.
\itemize{
\item Returns median junction read counts in tissues of a given gene from all known transcripts along with the hierarchical clustering results of tissues and genes, based on junction expression, in Newick format.
\item Results may be filtered by dataset, gene or tissue, but at least one gene must be provided.
\item The hierarchical clustering is performed by calculating Euclidean distances and using the average linkage method.
\item \strong{This endpoint is not paginated.}
}

By default, this service queries the latest GTEx release.

\href{https://gtexportal.org/api/v2/redoc#tag/Expression-Data-Endpoints/operation/get_clustered_median_junction_expression_api_v2_expression_clusteredMedianJunctionExpression_get}{GTEx Portal API documentation}
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_clustered_median_junction_expression(gencodeIds = c(
  "ENSG00000203782.5",
  "ENSG00000132693.12"
))

# clustering data is stored as an attribute "clusters"
result <- get_clustered_median_junction_expression(c(
  "ENSG00000203782.5",
  "ENSG00000132693.12"
))
attr(result, "clusters")

# process clustering data with the ape package
# install.packages("ape")
# phylo_tree <- ape::read.tree(text = attr(result, "clusters")$tissue)
# plot(phylo_tree)
# print(phylo_tree)
\dontshow{\}) # examplesIf}
}
\seealso{
Other Expression Data Endpoints: 
\code{\link{get_clustered_median_exon_expression}()},
\code{\link{get_clustered_median_gene_expression}()},
\code{\link{get_clustered_median_transcript_expression}()},
\code{\link{get_expression_pca}()},
\code{\link{get_gene_expression}()},
\code{\link{get_median_exon_expression}()},
\code{\link{get_median_gene_expression}()},
\code{\link{get_median_junction_expression}()},
\code{\link{get_median_transcript_expression}()},
\code{\link{get_single_nucleus_gex}()},
\code{\link{get_single_nucleus_gex_summary}()},
\code{\link{get_top_expressed_genes}()}
}
\concept{Expression Data Endpoints}
