% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_news_item.R
\name{get_news_item}
\alias{get_news_item}
\title{Get News Item}
\usage{
get_news_item(
  page = 0,
  itemsPerPage = getOption("gtexr.itemsPerPage"),
  .verbose = getOption("gtexr.verbose"),
  .return_raw = FALSE
)
}
\arguments{
\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250). Set globally to maximum value
100000 with \code{options(list(gtexr.itemsPerPage = 100000))}.}

\item{.verbose}{Logical. If \code{TRUE} (default), print paging information. Set
to \code{FALSE} globally with \code{options(list(gtexr.verbose = FALSE))}.}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
Getting all the news items from the database that are current.

\href{https://gtexportal.org/api/v2/redoc#tag/Admin-Endpoints/operation/get_news_item_api_v2_admin_newsItem_get}{GTEx Portal API documentation}.
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_news_item()
\dontshow{\}) # examplesIf}
}
\seealso{
Other Admin Endpoints: 
\code{\link{get_maintenance_message}()}
}
\concept{Admin Endpoints}
