% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-generics.R
\name{cluster_shade}
\alias{cluster_shade}
\alias{cluster_shade.default}
\alias{cluster_shade.matrix}
\alias{cluster_shade.FitLandDF}
\title{Cluster Shade Metric for a GLCM}
\usage{
cluster_shade(x, ...)

\method{cluster_shade}{default}(x, ...)

\method{cluster_shade}{matrix}(x, ...)

\method{cluster_shade}{FitLandDF}(x, nlevels, ...)
}
\arguments{
\item{x}{gray-level co-occurrence matrix}

\item{...}{additional parameters}

\item{nlevels}{desired number of discrete gray levels}
}
\value{
double
}
\description{
Calculate the cluster shade feature or metric for a gray-level co-occurrence
matrix. For definition and application, see Lofstedt et al. (2019)
\doi{10.1371/journal.pone.0212110}.
}
\examples{
## calculate cluster shade of arbitrary GLCM
# define arbitrary GLCM
x <- matrix(1:16, nrow = 4)

# normalize
n_x <- normalize_glcm(x)

# calculate cluster shade
cluster_shade(n_x)

## calculate cluster shade of arbitrary fitness landscape
# create fitness landscape using FitLandDF object
vals <- runif(64)
vals <- array(vals, dim = rep(4, 3))
my_landscape <- fitscape::FitLandDF(vals)

# calculate cluster shade of fitness landscape, assuming 2 discrete gray levels
cluster_shade(my_landscape, nlevels = 2)

## confirm value of cluster shade for fitness landscape
# extract normalized GLCM from fitness landscape
my_glcm <- get_comatrix(my_landscape, discrete = equal_discrete(2))

# calculate cluster shade of extracted GLCM
cluster_shade(my_glcm)  # should match value of above cluster_shade function call
}
