% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_abbreviation.R
\name{modify_abbreviation}
\alias{modify_abbreviation}
\alias{remove_abbreviation}
\title{Modify Abbreviations}
\usage{
modify_abbreviation(x, abbreviation, text_interpret = c("md", "html"))

remove_abbreviation(x, abbreviation = NULL)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
A gtsummary object}

\item{abbreviation}{(\code{string})\cr
a string. In \code{remove_abbreviation()}, the default value is \code{NULL}, which
will remove all abbreviation source notes.}

\item{text_interpret}{(\code{string})\cr
String indicates whether text will be interpreted with
\code{\link[gt:md]{gt::md()}} or \code{\link[gt:html]{gt::html()}}. Must be \code{"md"} (default) or \code{"html"}.
Applies to tables printed with \code{{gt}}.}
}
\value{
Updated gtsummary object
}
\description{
All abbreviations will be coalesced when printing the final table into
a single source note.
}
\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed(c("broom", "broom.helpers"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
tbl_summary(
  trial,
  by = trt,
  include = age,
  type = age ~ "continuous2"
) |>
  modify_table_body(~dplyr::mutate(.x, label = sub("Q1, Q3", "IQR", x = label))) |>
  modify_abbreviation("IQR = Interquartile Range")

# Example 2 ----------------------------------
lm(marker ~ trt, trial) |>
  tbl_regression() |>
  remove_abbreviation("CI = Confidence Interval")
\dontshow{\}) # examplesIf}
}
