% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc-to-cells.R
\name{sfc_to_cells}
\alias{sfc_to_cells}
\title{Convert sf geometry to H3 Cells}
\usage{
sfc_to_cells(x, resolution, containment = "intersect")
}
\arguments{
\item{x}{for \code{h3_from_points()} an object of class \code{sfc_POINT}. For \code{h3_from_strings()} a character vector of H3 index IDs. For \code{h3_from_xy()} a numeric vector of longitudes.}

\item{resolution}{an integer indicating the H3 cell resolution. Must be between 0 and 15 inclusive.}

\item{containment}{default \code{"intersect"}. Must be one of \code{"intersect"},
\code{"centroid"}, or \code{"boundary"}. See details.}
}
\value{
An H3 vector.
}
\description{
Given a vector of sf geometries (class \code{sfc}) create a list of \code{H3} vectors.
Each list element contains the vector of H3 cells that cover the geometry.
}
\details{
Note, use \code{flatten_h3()} to reduce the list to a single vector.

The \href{https://docs.rs/h3o/0.4.0/h3o/geom/enum.ContainmentMode.html}{Containment Mode} determines if an H3 cell should be returned.
\itemize{
\item \code{"centroid"} returns every cell whose centroid are contained inside of a polygon. This is the fastest option but may not cover the entire polygon.
\item \code{"boundary"} this returns the cells which are completely contained by the polygon. Much of a polygon might not be covered using this approach.
\item \code{"intersect"} ensures that a polygon is entirely covered. If an H3 cell comes in contact with the polygon it will be returned. This is the default.
\item \code{"contains"} behaves the same as \code{"intersect"}, but also handles the case where the geometry is being covered by a cell without intersecting with its boundaries. In such cases, the covering cell is returned.
}
}
\examples{
if (interactive() && rlang::is_installed("sf")) {
  nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)
  geo <- sf::st_geometry(nc)
  cells <- sfc_to_cells(geo, 5)

  head(cells)

  plot(flatten_h3(cells))
}

}
