% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_chow.R
\name{hcp_chow}
\alias{hcp_chow}
\title{Chow Test (structural break)}
\usage{
hcp_chow()
}
\value{
\code{hcp_chow} object
}
\description{
Change-point detection for linear models using F-based structural break tests from the strucchange package \url{doi:10.18637/jss.v007.i02}.
It wraps the Fstats and breakpoints implementation available in the strucchange library.
}
\examples{
library(daltoolbox)

# Load change-point example data
data(examples_changepoints)

# Use a simple example
dataset <- examples_changepoints$simple
head(dataset)

# Configure the Chow detector
model <- hcp_chow()

# Fit the detector (no-op for Chow)
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected change points
print(detection[(detection$event),])

}
