% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{osteoarthritis_df}
\alias{osteoarthritis_df}
\title{Data of 2,585 Participants in the Osteoarthritis Initiative (OAI) Project}
\format{
A data frame with 2,585 observations and 7 variables:
\describe{
  \item{AGE}{Integer vector indicating the participant's age}
  \item{SEX}{Factor indicating the participant's sex (2 levels)}
  \item{BMI}{Numeric vector indicating the body mass index of the participant}
  \item{RAC}{Factor indicating the participant's race (4 levels)}
  \item{SMK}{Factor indicating the smoking status (2 levels)}
  \item{OSP}{Factor indicating osteoarthritis status at baseline (2 levels)}
  \item{KOA}{Factor indicating knee osteoarthritis status at follow-up (2 levels)}
}
}
\source{
Data taken from the MatchThem package version 1.2.1.
}
\usage{
data(osteoarthritis_df)
}
\description{
This dataset, osteoarthritis_df, is a data frame containing demographic and clinical
information of 2,585 individuals with or at risk of knee osteoarthritis. The dataset
includes variables such as age, sex, body mass index (BMI), race, smoking status,
and osteoarthritis-related outcomes. Some variables contain missing values, including
BMI (quantitative), race (categorical), smoking status (binary), and knee osteoarthritis
status at follow-up (binary).
}
\details{
The dataset name has been kept as 'osteoarthritis_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
healthmotionR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
