% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{surgerydat_df}
\alias{surgerydat_df}
\title{Simulated Surgery Procedures Data}
\format{
A data frame with 32,529 observations and 9 variables:
\describe{
  \item{entrytime}{Numeric vector indicating the patient’s entry time into the study (in days)}
  \item{survtime}{Numeric vector indicating survival time (in days)}
  \item{censorid}{Numeric indicator of censoring status}
  \item{unit}{Numeric vector identifying the hospital unit (1–45)}
  \item{exptheta}{Numeric vector indicating the true failure rate of the hospital}
  \item{psival}{Numeric vector indicating the hospital’s patient arrival rate (\eqn{\psi})}
  \item{age}{Numeric vector indicating the patient’s age (in years)}
  \item{sex}{Factor with 2 levels indicating patient sex}
  \item{BMI}{Numeric vector indicating the patient’s body mass index}
}
}
\source{
Data taken from the success package version 1.1.1.
}
\usage{
data(surgerydat_df)
}
\description{
This dataset, surgerydat_df, is a data frame containing simulated data of surgery
procedures performed at multiple hospitals. It includes information on patients,
their survival times, and hospital-specific risk characteristics.
}
\details{
The dataset comprises data from 45 simulated hospitals with patient arrivals
occurring within the first 400 days after the start of the study. Patient survival
times were determined using a risk-adjusted Cox proportional hazards model with
coefficients: age = 0.003, BMI = 0.02, and sexmale = 0.2, along with an exponential
baseline hazard rate \eqn{h_0(t, \lambda = 0.01) e^\mu}. Hospital-specific hazard rate
increases were sampled from a normal distribution:

\deqn{\theta \sim N(\log(1), sd = 0.4)}

This means that the average failure rate of hospitals in the dataset is the baseline
(\eqn{\theta = 0}), with some hospitals experiencing higher or lower rates. The true
failure rate is given in the variable \code{exptheta}. Patient arrival rates
(\eqn{\psi}) differ across hospitals:

\itemize{
  \item Hospitals 1–5 & 16–20: 0.5 patients per day (small hospitals)
  \item Hospitals 6–10 & 21–25: 1 patient per day (medium hospitals)
  \item Hospitals 11–15 & 26–30: 1.5 patients per day (large hospitals)
}

The dataset name has been kept as 'surgerydat_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
healthmotionR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been
modified in any way.
}
