% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfoldPredict.R
\name{kfoldPredict.hyper_gam}
\alias{kfoldPredict.hyper_gam}
\title{\eqn{k}-Fold Prediction of \link{hyper_gam} Model}
\usage{
kfoldPredict.hyper_gam(object, k, mc.cores = getOption("mc.cores"), ...)
}
\arguments{
\item{object}{a \link{hyper_gam} object}

\item{k}{\link[base]{integer} scalar}

\item{mc.cores}{\link[base]{integer} scalar, see function \link[parallel]{mclapply}}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \code{\link[=kfoldPredict.hyper_gam]{kfoldPredict.hyper_gam()}} returns a \link[base]{numeric} \link[base]{vector},
with \link[base]{attributes} for savvy developers
\describe{
\item{\code{attr(.,'fold')}}{\link[base]{integer} \link[base]{vector}, indices of the \eqn{i}-th fold}
\item{\code{attr(.,'sgn')}}{\link[base]{numeric} \link[base]{vector} of length-\eqn{k}, sign-adjustment for each fold}
\item{\code{attr(.,'no_sadj')}}{\link[base]{numeric} \link[base]{vector}, predictions without sign adjustment}
\item{\code{attr(.,'global_sadj')}}{\link[base]{numeric} \link[base]{vector}, predictions based on sign-adjustment by the complete data (instead of each fold)}
}
}
\description{
\eqn{k}-fold prediction of \link{hyper_gam} model.
}
\keyword{internal}
