% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R
\name{simulation}
\alias{simulation}
\alias{simulation,Ib-method}
\title{Generic for simulating from the object}
\usage{
simulation(object, control = list(...), ...)

\S4method{simulation}{Ib}(object, control = list(...), ...)
}
\arguments{
\item{object}{an object of class union "Ib"}

\item{control}{a control list}

\item{...}{further argument to pass}
}
\value{
simulated responses.
}
\description{
Method for simulating responses from an object.
}
\examples{

## bootstrap poisson regression
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
pois_fit <- glm(counts ~ outcome + treatment, family = poisson())

## make 100 paramtric bootstrap replicates
boot_dist <- simulate(pois_fit, nsim = 100)
}
