% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/margins.R
\name{newMarginMatrix}
\alias{newMarginMatrix}
\title{Create empty margin matrix}
\usage{
newMarginMatrix()
}
\description{
Use this to create an empty margin matrix (which facilitates
the use of magrittr syntax to enter margins)
}
\examples{
library(magrittr)
N <- 230 ## population total
## Horvitz Thompson estimator of the mean: 2.174
weightedMean(data_employees$movies, data_employees$weight, N)
## Enter calibration margins:
margins <- newMarginMatrix() \%>\%
  addMargin("category", c(0.35, 0.40, 0.25)) \%>\%
  addMargin("sex", c(0.6, 0.4)) \%>\%
  addMargin("department", c(0.45, 0.55)) \%>\%
  addMargin("salary", 470000)
## Compute calibrated weights with raking ratio method
wCal <- calibration(data=data_employees, marginMatrix=margins, colWeights="weight"
                    , method="raking", pct = TRUE, description=FALSE
                    , popTotal = N)
## Calibrated estimate: 2.471917
weightedMean(data_employees$movies, wCal, N)
}
