% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-build.R
\docType{class}
\name{trigrid-class}
\alias{trigrid-class}
\alias{trigrid}
\title{A triangular icosahedral grid}
\arguments{
\item{tessellation}{(\code{numeric}) An integer vector with the tessellation values. Each number
 describes the number of new edges replacing one original edge. Multiple series of tessellations
    are possible this way. The total tessellation is the product of the tessellation vector. 
Higher values result in more uniform cell sizes, but the larger number of tessellation series
increases the speed of lookup functions.}

\item{deg}{(\code{numeric}) The target edge length of the grid in degrees. If provided, the function will select the appropriate tessellation vector from the \code{\link{triguide}}-table, which is closest to the target. Note that these are unlikely to be the exact matches.}

\item{spacing}{(\code{numeric}) The target spacing of the grid in degrees. If provided, the function will select the appropriate tessellation vector from the \code{\link{triguide}}-table, which is closest to the target. Note that these are unlikely to be the exact matches.}

\item{sp}{(\code{logical}) Flag indicating whether the \code{\link[sp]{SpatialPolygons}} class representation of the grid
should be added to the object when the grid is calculated. If set to \code{TRUE} the \code{SpPolygons()} function will be run with with the resolution parameter set to 25. The 
 resulting object will be stored in slot \code{@sp}. As the calculation of this object can substantially increase the grid creation time,
 by default this argument has a value of \code{FALSE}. The \code{\link[sp]{SpatialPolygons}} class representation can be added on demand by running the function \code{newsp}.}

\item{graph}{(\code{logical}) Flag indicating whether the \code{'igraph'} class representation of the grid
should be added to the object when the grid is calculated. This argument defaults to \code{TRUE} because this option has only minor performance load on the grid 
constructor function. For familiarization with the
object structure, however, setting this parameter to \code{FALSE} might help, as invoking \code{\link[utils]{str}} on the \code{'igraph'} class slot of the class might flood the console.}

\item{radius}{(\code{numeric}) The radius of the grid. Defaults to the authalic radius of Earth.}

\item{center}{(\code{numeric}) The origin of the grid in the reference Cartesian coordinate system. Defaults to (0,0,0).}

\item{verbose}{(\code{logical}) Should messages be printed during grid creation?}
}
\value{
A triangular grid object, with class \code{trigrid}.
}
\description{
\code{trigrid()} creates a triangular grid based on the
   tessellation of an icosahedron.
}
\details{
The grid structure functions as a frame for data graining, plotting and spatial
calculations. Data can be stored in layers that are linked to the grid object. In the current version only the 
\code{facelayer} class is implemented, which allows the user to render data to the cells
of the grid, which are usually referred to as faces. 
The grid 'user interface' is made up of four primary tables: the \code{@vertices} table for the coordinates of the vertices,
	the \code{faceCenters} for the coordinates of the centers of faces,
the \code{faces} and the \code{edges} tables that contain which vertices form which faces and edges respectively.
In these tables, the faces and vertices are sorted to form spirals that go from the north pole in a counter-clockwise
direction. In case grid subsetting is performed these tables get truncated.

At finer resolutions, the large number of spatial elements render all calculations resource demanding and slow, 
therefore the hierarchical structure created during the tessellation procedure is retained for efficient implementation.
These data are stored in a list in the slot \code{@skeleton} and are 0-indexed integer tables for Rccp-based functions. \code{$v} 
stores vertex, \code{$f} the edge, and \code{$e} contains the edge data for plotting and calculations. In these tables
the original hierarchy based orderings of the units are retained, during subsetting, additional vectors are used to indicate
deactivation of these units. Any sort of meddling with the \code{@skeleton} object will lead to unexpected behavior.
}
\section{Slots}{

\describe{
\item{\code{vertices}}{Matrix of the vertex XYZ coordinates.}

\item{\code{faces}}{Matrix of the verticies forming the faces.}

\item{\code{edges}}{Matrix of the vertices forming the edges.}

\item{\code{tessellation}}{Contains the tessellation vector.}

\item{\code{orientation}}{Contains the grid orientation in xyz 3d space, values in radian relative to the (0,1,0) direction.}

\item{\code{center}}{is the xyz coordinates of the grids origin/center.}

\item{\code{div}}{vector contains the number of faces that a single face of the previous tessellation level is decomposed to.}

\item{\code{faceCenters}}{contains the xyz coordinates of the centers of the faces on the surface of the sphere.}

\item{\code{belts}}{Vector of integers indicating the belt the face belongs to.}

\item{\code{edgeLength}}{the length of an average edge in km and degrees.}

\item{\code{graph}}{an 'igraph' class graph object.}

\item{\code{length}}{integer vector of length=3. The number of vertices, edges and faces in this order.}

\item{\code{crs}}{a CRS class object, by design this is the authalic sphere (ESRI:37008)}

\item{\code{r}}{the radius of the grid}

\item{\code{sp}}{The SpatialPolygons representation of the grid. If missing, it can be created with newsp().}

\item{\code{sf}}{The sf representation of the grid. If missing, it can be created with newsf().}

\item{\code{skeleton}}{data tables with sequential indexing for the C functions.}
}}

\examples{
# single tessellation value
g <- trigrid(c(8))
g
# series of tessellations
g1 <- trigrid(c(2,3,4))
g1
# based on approximate size (4 degrees edge length)
g2 <- trigrid(deg=4) 
}
