% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_mean.R
\name{na_mean}
\alias{na_mean}
\title{Missing Value Imputation by Mean Value}
\usage{
na_mean(x, option = "mean", maxgap = Inf)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}})
object in which missing values shall be replaced}

\item{option}{Algorithm to be used. Accepts the following input:
\itemize{
\item{"mean" - take the mean for imputation (default choice)}
\item{"median" - take the median for imputation}
\item{"mode" - take the mode for imputation}
\item{"harmonic" - take the harmonic mean}
\item{"geometric" - take the geometric mean}
}}

\item{maxgap}{Maximum number of successive NAs to still perform imputation on.
Default setting is to replace all NAs without restrictions. With this
option set, consecutive NAs runs, that are longer than 'maxgap' will
be left NA. This option mostly makes sense if you want to
treat long runs of NA afterwards separately.}
}
\value{
Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}})
object (dependent on given input at parameter x)
}
\description{
Missing value replacement by mean values. Different means
like median, mean, mode possible.
}
\details{
Missing values get replaced by overall mean values. The function
calculates the mean, median, mode, harmonic or geometric mean over all the non-NA
values and replaces all NAs with this value. Option 'mode' replaces NAs with
the most frequent value in the time series. If two or more values occur equally frequent,
the function imputes the lower value. Due to their calculation formula geometric and harmonic
mean are not well defined for negative values or zero values in the input series.

In general using the mean for imputation imputation is mostly a suboptimal choice and should
be handled with great caution.
}
\examples{
# Prerequisite: Create Time series with missing values
x <- ts(c(2, 3, 4, 5, 6, NA, 7, 8))

# Example 1: Perform imputation with the overall mean
na_mean(x)

# Example 2: Perform imputation with overall median
na_mean(x, option = "median")

# Example 3: Same as example 1, just written with pipe operator
x \%>\% na_mean()
}
\seealso{
\code{\link[imputeTS]{na_interpolation}},
\code{\link[imputeTS]{na_kalman}}, \code{\link[imputeTS]{na_locf}},
\code{\link[imputeTS]{na_ma}},
\code{\link[imputeTS]{na_random}}, \code{\link[imputeTS]{na_replace}},
\code{\link[imputeTS]{na_seadec}}, \code{\link[imputeTS]{na_seasplit}}
}
\author{
Steffen Moritz
}
