% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_fup_uc.R
\name{calc_fup_uc}
\alias{calc_fup_uc}
\title{Calculate Fraction Unbound in Plasma (Fup) from Ultracentrifugation (UC) Data
with Bayesian Modeling (Level-4)}
\usage{
calc_fup_uc(
  FILENAME,
  data.in,
  TEMP.DIR = NULL,
  NUM.CHAINS = 5,
  NUM.CORES = 2,
  RANDOM.SEED = 1111,
  SEED.SET = NULL,
  good.col = "Verified",
  JAGS.PATH = NA,
  save.MCMC = FALSE,
  sig.figs = 3,
  INPUT.DIR = NULL,
  OUTPUT.DIR = NULL,
  verbose = TRUE
)
}
\arguments{
\item{FILENAME}{(Character) A string used to identify the input level-2 file,
"<FILENAME>-fup-UC-Level2.tsv", and to name the exported model results. 
This argument is required no matter which method of specifying input data is used. 
(Defaults to \code{NULL}.)}

\item{data.in}{A level-2 data frame generated from the 
\code{format_fup_uc} function with a verification column added by 
\code{sample_verification}. Complement with manual verification if needed.}

\item{TEMP.DIR}{(Character) Temporary directory to save intermediate files. If 
\code{NULL}, all files will be written to the user's per-session temporary directory.
(Defaults to \code{NULL}.)}

\item{NUM.CHAINS}{(Numeric) The number of Markov Chains to use. (Defaults to 5.)}

\item{NUM.CORES}{(Numeric) The number of processors to use for
parallel computing. (Defaults to 2.)}

\item{RANDOM.SEED}{(Numeric) The seed used by the random number generator.
(Defaults to 1111.)}

\item{SEED.SET}{(Numeric Vector) A set of seeds used by the random number generator for each chain.
Should be unique for each chain and vector length should equal the total number of chains.
(Default is \code{NULL}.)}

\item{good.col}{(Character) Column name indicating which rows have been
verified for analysis, valid data rows are indicated with "Y".
(Defaults to "Verified".)}

\item{JAGS.PATH}{(Character) Computer specific file path to JAGS software.
(Defaults to `NA`.)}

\item{save.MCMC}{(Logical) When set to \code{TRUE}, will export the MCMC results
as an .RData file. (Defaults to \code{FALSE}.)}

\item{sig.figs}{(Numeric) The number of significant figures to round the exported unverified data (level-2). 
The exported result table (level-4) is left unrounded for reproducibility.
(Note: console print statements are also rounded to specified significant figures.)
(Defaults to \code{3}.)}

\item{INPUT.DIR}{(Character) Path to the directory where the input level-2 file exists. 
If \code{NULL}, looking for the input level-2 file in the current working
directory. (Defaults to \code{NULL}.)}

\item{OUTPUT.DIR}{(Character) Path to the directory to save the output file. 
If \code{NULL}, the output file will be saved to the user's per-session temporary
directory or \code{INPUT.DIR} if specified. (Defaults to \code{NULL}.)}

\item{verbose}{(\emph{logical}) Indicate whether printed statements should be shown.
(Default is TRUE.)}
}
\value{
A list of two objects: 
\enumerate{
   \item{Results: A level-4 data frame with Bayesian estimated fraction unbound
   in plasma (Fup) and credible intervals for all compounds in the input file.
   Column includes:
   Compound.Name - compound name,
   Lab.Compound.Name - compound name used by the laboratory,
   DTXSID - EPA's DSSTox Structure ID,
   Fup.point - point estimate of Fup,
   Fup.Med - posterior median,
   Fup.Low - 2.5th quantile,
   Fup.High - 97.5th quantile,
   Fstable.Med - posterior median of stability fraction,
   Fstable.Low - 2.5th quantile,
   Fstable.High - 97.5th quantile.}
   \item{coda: A runjags-class object containing results from JAGS model.}
}
}
\description{
This function estimates the fraction unbound in plasma (Fup) and credible
intervals with a Bayesian modeling approach, via MCMC simulations.
Data used in modeling is collected from Ultracentrifugation (UC) Fup assays 
\insertCite{redgrave1975separation}{invitroTKstats}.
Fup and the credible interval are calculated from the MCMC posterior samples
and the function returns a summary table (level-4) along with the full set of
MCMC results.
}
\details{
The input to this function should be "level-2" data. Level-2 data is level-1,
data formatted with the \code{\link{format_fup_uc}} function, and curated
with a verification column. "Y" in the verification column indicates the
data row is valid for analysis. 

Note: By default, this function writes files to the user's per-session temporary
directory. This temporary directory is a per-session directory whose path can 
be found with the following code: \code{tempdir()}. For more details, see 
\url{https://www.collinberke.com/til/posts/2023-10-24-temp-directories/}.

Users must specify an alternative path with the \code{TEMP.DIR}
argument if they want the intermediate files exported to another path. Exported 
intermediate files include the summary results table (.tsv), JAGS model (.RData),
and any "unverified" data excluded from the analysis (.tsv). Users must specify 
an alternative path with the \code{OUTPUT.DIR} argument if they want the final 
output file exported to another path. The exportef final output file is the 
summary results table (.RData). 

As a best practice, \code{INPUT.DIR} (when importing a .tsv file) and/or 
\code{OUTPUT.DIR} should be specified to simplify the process of importing and
exporting files. This practice ensures that the exported files can easily be 
found and will not be exported to a temporary directory. 

The data frame of observations should be annotated according to
these types:
\tabular{rrrrr}{
  Calibration Curve \tab CC\cr
  Ultracentrifugation Aqueous Fraction \tab AF\cr
  Whole Plasma T1h Sample  \tab T1\cr
  Whole Plasma T5h Sample \tab T5\cr
}
We currently require CC, AF, and T5 data. T1 data are optional.

Additional User Notification(s):

\itemize{
   \item{runjags::findjags() may not work as \code{JAGS.PATH} argument. Instead,
   may need to manually remove the trailing path such that \code{JAGS.PATH} only
   contains path information through "/x64" (e.g. \code{JAGS.PATH} = "/Program Files/JAGS/JAGS-4.3.1/x64").}
}
}
\examples{
## Example 1: loading level-2 using data.in and export all files to the user's
## temporary directory
\dontrun{
level2 <- invitroTKstats::fup_uc_L2

# JAGS.PATH should be changed to user's specific computer file path to JAGS software.
# findJAGS() from runjags package is a handy function to find JAGS path automatically.
# In certain circumstances or cases, one may need to provide the absolute path to JAGS.
path.to.JAGS <- runjags::findJAGS()
level4 <- calc_fup_uc(FILENAME = "Example1",
                      data.in = level2,
                      NUM.CORES=2,
                      JAGS.PATH=path.to.JAGS)
}

## Example 2: importing level-2 from a .tsv file and export all files to same 
## location as INPUT.DIR 
\dontrun{
# Refer to sample_verification help file for how to export level-2 data to a directory.
# JAGS.PATH should be changed to user's specific computer file path to JAGS software.
# findJAGS() from runjags package is a handy function to find JAGS path automatically.
# In certain circumstances or cases, one may need to provide the absolute path to JAGS.
# Will need to replace FILENAME and INPUT.DIR with name prefix and location of level-2 'tsv'.
path.to.JAGS <- runjags::findJAGS()
level4 <- calc_fup_uc(# e.g. replace with "Examples" from "Examples-fup-UC-Level2.tsv"
                      FILENAME="<level-2 FILENAME prefix>",
                      NUM.CORES=2,
                      JAGS.PATH=path.to.JAGS,
                      INPUT.DIR = "<level-2 FILE LOCATION>")
}

}
\references{
\insertRef{redgrave1975separation}{invitroTKstats}
}
\author{
John Wambaugh and Chantel Nicolas
}
