% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{clint_PREJAGS}
\alias{clint_PREJAGS}
\title{Clint Level-4 PREJAGS arguments}
\format{
A named list with 26 elements: \describe{
\item{\code{obs}}{\code{Response} of the "Cvst" sample types for the tested compound}
\item{\code{Test.Nominal.Conc}}{Unique \code{Test.Nominal.Conc} values (expected initial concentration) of "Cvst" sample types}
\item{\code{Num.cal}}{Unique number of \code{Calibration} values}
\item{\code{Num.obs}}{Number of \code{Response} of the "Cvst" sample types for the tested compound}
\item{\code{obs.conc}}{Indices of the \code{Test.Nominal.Conc} values that corresponds to the "Cvst" sample types' \code{Test.Nominal.Conc}}
\item{\code{obs.time}}{\code{Time} of the "Cvst" sample types for the tested compound}
\item{\code{obs.cal}}{Indices of the unique "Cvst" \code{Calibration} values that corresponds to the "Cvst" sample types' \code{Calibration}}
\item{\code{obs.Dilution.Factor}}{\code{Dilution Factor} of the "Cvst" sample types for the tested compound (number of times the sample was diluted)}
\item{\code{Num.blank.obs}}{Number of "Blank" sample types for the tested compound}
\item{\code{Blank.obs}}{\code{Response} of the "Blank" sample types for the tested compound}
\item{\code{Blank.cal}}{Indices of the unique "Blank" \code{Calibration} values that corresponds to the "Blank" sample types' \code{Calibration}}
\item{\code{Blank.Dilution.Factor}}{\code{Dilution Factor} of the "Blank" sample types for the tested compound (number of times the sample was diluted)}
\item{\code{Num.cc}}{Number of "CC" sample types with non-NA \code{Test.Compound.Conc} values for the tested compound}
\item{\code{cc.obs.conc}}{\code{Test.Compound.Conc} (non-NA) of the "CC" sample types for the tested compound}
\item{\code{cc.obs}}{\code{Response} of the "CC" sample types with non-NA \code{Test.Compound.Conc} for the tested compound}
\item{\code{cc.obs.cal}}{Indices of the unique "CC" \code{Calibration} values that corresponds to the "CC" sample types' \code{Calibration}}
\item{\code{cc.obs.Dilution.Factor}}{\code{Dilution Factor} of the "CC" sample types (number of times the sample was diluted) with non-NA \code{Test.Compound.Conc} for the tested compound}
\item{\code{Num.abio.obs}}{Number of "Inactive" samples types for the tested compound}
\item{\code{abio.obs}}{\code{Response} of the "Inactive" sample types for the tested compound}
\item{\code{abio.obs.conc}}{Indices of the \code{Test.Nominal.Conc} values that corresponds to the "Inactive" sample types' \code{Test.Nominal.Conc}}
\item{\code{abio.obs.time}}{\code{Time} of the "Inactive" sample types for the tested compound}
\item{\code{abio.obs.cal}}{Indices of the unique "Inactive" \code{Calibration} values that corresponds to the "Inactive" sample types' \code{Calibration}}
\item{\code{abio.obs.Dilution.Factor}}{\code{Dilution Factor} of the "Inactive" sample types for the tested compound (number of times the sample was diluted)}
\item{\code{DECREASE.PROB}}{Prior probability that a chemical will decrease in the assay. (Defaults to 0.5.)}
\item{\code{SATURATE.PROB}}{Prior probability that a chemicals rate of metabolism will decrease between 1 and 10 uM. (Defaults to 0.25.)}
\item{\code{DEGRADE.PROB}}{Prior probability that a chemical will be unstable (degrade abiotically) in the assay. (Defaults to 0.05.)}
}
}
\usage{
clint_PREJAGS
}
\description{
The arguments given to JAGS for the tested compound during level-4 processing of mass spectrometry
measurements of intrinsic hepatic clearance (Clint) for cryopreserved 
pooled human hepatocytes. Chemicals were per- and poly-fluorinated alkyl substance
(PFAS) samples. The experiments were led by Dr.s Marci Smeltz and Barbara Wetmore 
\insertCite{smeltz2023plasma}{invitroTKstats}. This list is overwritten for each tested
compound. Therefore, only contains arguments given to JAGS for the last tested compound.
}
\references{
\insertRef{shibata2002prediction}{invitroTKstats}

\insertRef{smeltz2023plasma}{invitroTKstats}
}
\keyword{datasets}
