% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_params_2comp.R
\name{get_params_2comp}
\alias{get_params_2comp}
\title{Get parameters for 2-compartment model}
\usage{
get_params_2comp(
  data,
  lower_bound = NULL,
  upper_bound = NULL,
  param_units = alist(kelim = paste0("1/", unique(Time_trans.Units)), V1 = paste0("(",
    unique(Dose.Units), ")/(", unique(Conc.Units), ")"), k21 = paste0("1/",
    unique(Time_trans.Units)), k12 = paste0("1/", unique(Time_trans.Units)), Fgutabs =
    "unitless fraction", kgutabs = paste0("1/", unique(Time_trans.Units)), Fgutabs_V1 =
    paste0("(", unique(Conc.Units), ")/(", unique(Dose.Units), ")"), Rblood2plasma =
    "unitless ratio"),
  ...
)
}
\arguments{
\item{data}{The data set to be fitted (e.g. the result of [preprocess_data()])}

\item{lower_bound}{A mapping specified using a call to [alist()],
giving the lower bounds for each variable, as expressions which may include
variables in `data`.}

\item{upper_bound}{A mapping specified using a call to [alist()],
giving the upper bounds for each variable, as expressions which may include
variables in `data`.}

\item{param_units}{A mapping specified using a call to [alist()],
giving the units for each variable, as expressions which may include
variables in `data`.}

\item{...}{Other parameters that can be specified in `pk_model`.}
}
\value{
A `data.frame`with the following variables:
\itemize{
\item `param_name`: Character: Names of the model parameters
\item `param_units`: Character: Units of the model parameters
\item `optimize_param`: TRUE if each parameter is to be estimated from the data; FALSE otherwise
\item `use_param`: TRUE if each parameter is to be used in evaluating the model; FALSE otherwise
\item`lower_bounds`: Numeric: The lower bounds for each parameter
\item `upper_bounds`: Numeric: The upper bounds for each parameter
\item `start`: Numeric: The starting guesses for each parameter
}
}
\description{
Get parameters for 2-compartment model and determine whether each is to be
estimated from the data
}
\details{
The full set of model parameters for the 2-compartment model includes `V1`,
`kelim`, `k12`, `k21`, `kgutabs`,`Fgutabs`, and `Rblood2plasma`. Whether each one can be
estimated from the data depends on what routes of administration are included
in the data.
}
\section{IV data, no oral data}{


If IV dosing data are available, but no oral dosing data are available, then
only the parameters `V1`, `kelim`, `k12`, and `k21` will be estimated from
the data. The parameters `kgutabs` and `Fgutabs` cannot be estimated from IV
data alone.
}

\section{Oral data, no IV data}{


If oral dosing data are available, but no IV dosing data are available, then
the parameters `kelim`, `k12`, `k21`, and `kgutabs` will be estimated from
the data. However, the parameters `Fgutabs` and `V1` cannot be identified
separately. From oral data alone, only the ratio `Fgutabs/V1` can be
identified. This ratio is represented by a single parameter named
`Fgutabs_V1`. `Fgutabs` and `V1` will not be optimized, but `Fgutabs_V1` will
be optimized, along with `kelim`, `k12`, `k21`, and `kgutabs`.
}

\section{Oral data and IV data}{

If both oral and IV dosing data are available, then `V1`, `kelim`, `k12`,
`k21`, `kgutabs`, and `Fgutabs` will all be estimated from the data.
}

\section{Default lower and upper bounds for each parameter}{

\subsection{Default lower and upper bounds for time constants `kelim`, `kgutabs`,
`k12`, and `k21`.}{
Default bounds for time constants `kelim` and `kgutabs` are set based on
the time scale of the available data.

The lower bounds are based on the assumption that elimination, absorption,
and distribution are very slow compared to the time scale of the study.
Specifically, the lower bounds assume thatelimination, absorption, and
distribution half-lives are twice as long as the duration of the available
study data, or `2*max(Time_trans)`. Under this assumption, the corresponding
elimination, absorption, and distribution time constants would be
`log(2)/(2*max(Time_trans))`. Therefore, the default lower bounds for
`kelim`, `kgutabs`, `k12`, and `k21` are `log(2)/(2*max(Time_trans))`.

Upper bounds are based on the opposite assumption: that elimination,
absorption, and distribution are very fast compared to the time scale of the
study. Specifically, the upper bounds assume that the elimination,
absorption, and distribution half-lives are half as long as the time of the
first observation after time 0, or `0.5*min(Time_trans[Time_trans>0])`. Under
this assumption, the correspondingelimination, absorption, and distribution
time constants would be `log(2)/(0.5*min(Time_trans[Time_trans>0]))`.
Therefore, the default lower bounds for `kelim`, `kgutabs`, `k12`, and `k21`
are `log(2)/(0.5*min(Time_trans[Time_trans>0]))`.
}
\subsection{Default lower and upper bounds for `V1`}{
By default, the lower bound for `V1` is 0.01, and the upper bound for
`V1` is 100. These values were chosen based on professional judgment.
}
\subsection{Default lower and upper bounds for `Fgutabs`}{
By default, the lower bound for `Fgutabs` is 0.0, and the upper bound for
`Fgutabs` is 1. These are simply the bounds of the physically-meaningful
range for a fraction.
}
\subsection{Default lower and upper bounds for `Fgutabs_V1`}{
By default, the lower bound for the ratio `Fgutabs_V1` is 0.01, and the
upper bound is 100. These values were chosen based on professional judgment.
}
\subsection{Default lower and upper bounds for `Rblood2plasma`}{
By default, the lower bound for the blood:plasma partition coefficient
`Rblood2plasma` is 0.01, and the upper bound is 100. These values were chosen
based on professional judgment.
}
}

\section{Starting values for each parameter}{


Starting values for each parameter (starting guesses for the numerical
optimizer) are derived from the data using [get_starts_2comp()].

If the starting values returned by [get_starts_2comp()] fall outside the
bounds for any parameter(s), then the starting value will be reset to a value
halfway between the lower and upper bounds for that parameter.
}

\section{Blood and plasma data}{


If both blood and plasma data are available, then `Rblood2plasma` will be estimated from the data.
}

\section{Only one of blood or plasma data}{


If only one of blood or plasma data are available, then `Rblood2plasma` will be
held constant at 1, not estimated from the data.
}

\seealso{
Other 2-compartment model functions: 
\code{\link{auc_2comp}()},
\code{\link{cp_2comp}()},
\code{\link{cp_2comp_dt}()},
\code{\link{get_starts_2comp}()},
\code{\link{tkstats_2comp}()},
\code{\link{transformed_params_2comp}()}

Other get_params functions: 
\code{\link{get_params_1comp}()},
\code{\link{get_params_flat}()}

Other built-in model functions: 
\code{\link{auc_1comp}()},
\code{\link{auc_2comp}()},
\code{\link{auc_flat}()},
\code{\link{auc_httk_gas_pbtk}()},
\code{\link{cp_1comp}()},
\code{\link{cp_2comp}()},
\code{\link{cp_2comp_dt}()},
\code{\link{cp_flat}()},
\code{\link{cp_httk_gas_pbtk}()},
\code{\link{get_params_1comp}()},
\code{\link{get_params_flat}()},
\code{\link{get_params_httk_gas_pbtk}()},
\code{\link{get_starts_1comp}()},
\code{\link{get_starts_2comp}()},
\code{\link{get_starts_flat}()},
\code{\link{get_starts_httk_gas_pbtk}()},
\code{\link{tkstats_2comp}()},
\code{\link{transformed_params_2comp}()}
}
\author{
Caroline Ring, Gilberto Padilla Mercado
}
\concept{2-compartment model functions}
\concept{built-in model functions}
\concept{get_params functions}
