% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_knitr_table.R
\name{create_knitr_table}
\alias{create_knitr_table}
\title{Create an output-independent, formatted kable table}
\usage{
create_knitr_table(
  data_table,
  digits = NULL,
  caption = NA,
  col.names = NULL,
  col_width = NULL,
  width_unit = "cm",
  col_align = NULL,
  border_right_cols = NULL,
  bold_cols = NULL,
  bootstrap_options = c("striped", "hover", "condensed"),
  latex_options = NULL,
  output_format = NULL,
  keep_pdf = FALSE,
  latex_header_includes = c("\\\\usepackage[magyar]{babel}",
    "\\\\usepackage[utf8]{inputenc}")
)
}
\arguments{
\item{data_table}{A \code{data.frame}, tibble, named matrix, or \code{knitr_kable} object.}

\item{digits}{Number of digits to display for numeric variables.
Defaults to \code{getOption("digits")}.}

\item{caption}{Optional table caption. Defaults to \code{NA} (no caption).}

\item{col.names}{Column names for the table. If \code{NULL}, uses
\code{names(data_table)}.}

\item{col_width}{Numeric vector of column widths. If \code{NULL}, defaults to
2 for the first column and equal share for the rest.}

\item{width_unit}{Character. Unit for column widths (default \code{"cm"}).}

\item{col_align}{Column alignment. Defaults to \code{"l"} for the first column,
\code{"c"} for others.}

\item{border_right_cols}{Logical vector for right-hand column borders.
Defaults to \code{TRUE} for the first column, \code{FALSE} otherwise.}

\item{bold_cols}{Logical vector. If \code{TRUE}, makes the column bold.
Defaults to all \code{FALSE}.}

\item{bootstrap_options}{Passed to \code{\link[kableExtra:kable_styling]{kableExtra::kable_styling()}} for
HTML output. Defaults to \code{c("striped", "hover", "condensed")}.}

\item{latex_options}{Passed to \code{\link[kableExtra:kable_styling]{kableExtra::kable_styling()}} for
LaTeX output. Defaults to \code{c("scale_down", "striped")}.}

\item{output_format}{Character: \code{"html"}, \code{"latex"}, or \code{"image"}.
If \code{NULL}, auto-detects from knitr options.}

\item{keep_pdf}{Logical. Only relevant for \code{output_format = "image"}.
Defaults to \code{FALSE}.}

\item{latex_header_includes}{Character vector of LaTeX headers to include.
Defaults to \code{c("\\\\usepackage[magyar]{babel}", "\\\\usepackage[utf8]{inputenc}")}.}
}
\value{
A \code{knitr_kable} object with styling applied.
}
\description{
Wrapper around \code{\link[knitr:kable]{knitr::kable()}} with sensible defaults
for alignment, borders, and formatting, compatible with HTML and LaTeX
output formats.
}
\keyword{internal}
