% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heightmap.R
\name{calc_heightmap_coords}
\alias{calc_heightmap_coords}
\title{Calculate voxel coordinates from a matrix where values in the matrix
indicate height above the ground}
\usage{
calc_heightmap_coords(
  mat,
  fill = NULL,
  scale = 1,
  flipx = FALSE,
  flipy = TRUE,
  ground = "xy",
  solid = TRUE,
  check_visibility = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{mat}{integer matrix. The matrix will be interpreted as cubes flat on the
page, with the value in the matrix interpreted as the height above the page.}

\item{fill}{matrix of colours the same dimensions as the \code{mat} argument.
Default: NULL.   If \code{fill} is not NULL, 
then a \code{fill} column will be included in the final returned coordinates.}

\item{scale}{scale factor for values in matrix. Default = 1}

\item{flipx, flipy}{Should the matrix be flipped in the horizontal/vertical directions (respectively)?
Default: \code{flipx = FALSE}, \code{flipy = TRUE}.

Note: \code{flipy} defaults to \code{TRUE} as matrices are indexed
from the top-down, but the isometric coordinate space is increasing
from the bottom up.   Flipping the matrix vertically is usually 
what you want.}

\item{ground}{Orientation of the ground plane. Default: 'xy'.  Possible
values 'xz', 'xy'}

\item{solid}{Should the heightmap be made 'solid' i.e. without holes?
default: TRUE.  This can be an expensive operation in terms of 
both memory and CPU, but should be OK for simple examples.
Set to FALSE if things take too long.  This operation works by 
extruding cubes down from the top of the height map to the floor to 
ensure gaps do not appear when the slope is too great.}

\item{check_visibility}{Should non-visible cubes be removed? Default: FALSE.
If you plan on rotating or manipulating the returned coordinates then
this should definitely by FALSE.  If TRUE, then non-visible voxels 
will be entirely removed from the returned coordinates i.e. 
they will be missing if you change the rendering viewpoint from
the default.}

\item{verbose}{Be verbose? default: FALSE}
}
\value{
data.frame of voxel coordinates
}
\description{
Calculate voxel coordinates from a matrix where values in the matrix
indicate height above the ground
}
\examples{
# Plot the standard volcano 
mat <- volcano

# normalise height
mat <- mat - min(mat)

# Assign a distinct colour for each height value
val <- as.vector(mat)
val <- round(255 * val / max(val))
fill <- matrix("", nrow=nrow(mat), ncol=ncol(mat))
fill[] <- terrain.colors(256)[val + 1L]

# Calculate coordinates of heightmap, render as isocubes
coords <- calc_heightmap_coords(mat, fill = fill, scale = 0.3)
head(coords)
isocubesGrob(coords, size = 2, y = 0) |>
  grid::grid.draw()
}
