% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haps_functions.R
\name{haps_phylo}
\alias{haps_phylo}
\title{Organize information to create haplotypes using phylogenetic tree(s)}
\usage{
haps_phylo(obj = NULL, fn = NULL)
}
\arguments{
\item{obj}{Object containing phylogenetic tree(s).
This can be (1) a single \code{phylo} object
that represents all chromosomes in the genome or
(2) a \code{list} or \code{multiPhylo} object containing a \code{phylo} object for
each reference chromosome.
In the latter case, phylogenies will be assigned to chromosomes in the
order provided.
Defaults to \code{NULL}.}

\item{fn}{One or more string(s), each of which specifies the file name
of a NEWICK file containing a phylogeny.
If one name is provided, that phylogeny will be used for all chromosomes.
If more than one is provided, there must be a phylogeny for each reference
genome chromosome, and phylogenies will be assigned to chromosomes
in the order provided.
Defaults to \code{NULL}.}
}
\value{
A \code{haps_phylo_info} object containing information used in \code{create_haplotypes}
to create variant haplotypes.
This class is just a wrapper around a list containing phylogenetic tree
information for each reference chromosome, which you can view (but not change)
using the object's \code{phylo()} method.
}
\description{
This function organizes higher-level information for creating haplotypes from
phylogenetic tree(s) output as \code{phylo} or \code{multiPhylo} objects
(both from the \code{ape} package) or NEWICK files.
Note that all phylogenetic trees must be rooted and binary.
If using this function, I encourage you to cite \code{ape}. For citation
information, see output from \code{citation("ape")}.
}
\details{
See \code{?ape::write.tree} for writing phylogenies to an output file.
}
