% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-convolutional.R
\name{layer_conv_lstm_1d}
\alias{layer_conv_lstm_1d}
\title{1D Convolutional LSTM}
\usage{
layer_conv_lstm_1d(
  object,
  filters,
  kernel_size,
  strides = 1L,
  padding = "valid",
  data_format = NULL,
  dilation_rate = 1L,
  activation = "tanh",
  recurrent_activation = "hard_sigmoid",
  use_bias = TRUE,
  kernel_initializer = "glorot_uniform",
  recurrent_initializer = "orthogonal",
  bias_initializer = "zeros",
  unit_forget_bias = TRUE,
  kernel_regularizer = NULL,
  recurrent_regularizer = NULL,
  bias_regularizer = NULL,
  activity_regularizer = NULL,
  kernel_constraint = NULL,
  recurrent_constraint = NULL,
  bias_constraint = NULL,
  return_sequences = FALSE,
  return_state = FALSE,
  go_backwards = FALSE,
  stateful = FALSE,
  dropout = 0,
  recurrent_dropout = 0,
  ...
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{filters}{Integer, the dimensionality of the output space (i.e. the number of
output filters in the convolution).}

\item{kernel_size}{An integer or list of n integers, specifying the
dimensions of the convolution window.}

\item{strides}{An integer or list of n integers, specifying the strides of
the convolution. Specifying any stride value != 1 is incompatible with
specifying any \code{dilation_rate} value != 1.}

\item{padding}{One of \code{"valid"} or \code{"same"} (case-insensitive). \code{"valid"} means no
padding. \code{"same"} results in padding evenly to the left/right or up/down
of the input such that output has the same height/width dimension as the
input.}

\item{data_format}{A string, one of \code{channels_last} (default) or \code{channels_first}.
The ordering of the dimensions in the inputs. \code{channels_last} corresponds
to inputs with shape \verb{(batch, time, ..., channels)} while \code{channels_first}
corresponds to inputs with shape \verb{(batch, time, channels, ...)}. It
defaults to the \code{image_data_format} value found in your Keras config file
at \verb{~/.keras/keras.json}. If you never set it, then it will be
"channels_last".}

\item{dilation_rate}{An integer or list of n integers, specifying the
dilation rate to use for dilated convolution. Currently, specifying any
\code{dilation_rate} value != 1 is incompatible with specifying any \code{strides}
value != 1.}

\item{activation}{Activation function to use. By default hyperbolic tangent
activation function is applied (\code{tanh(x)}).}

\item{recurrent_activation}{Activation function to use for the recurrent step.}

\item{use_bias}{Boolean, whether the layer uses a bias vector.}

\item{kernel_initializer}{Initializer for the \code{kernel} weights matrix, used for
the linear transformation of the inputs.}

\item{recurrent_initializer}{Initializer for the \code{recurrent_kernel} weights
matrix, used for the linear transformation of the recurrent state.}

\item{bias_initializer}{Initializer for the bias vector.}

\item{unit_forget_bias}{Boolean. If TRUE, add 1 to the bias of the forget gate at
initialization. Use in combination with \code{bias_initializer="zeros"}. This
is recommended in \href{https://proceedings.mlr.press/v37/jozefowicz15.pdf}{Jozefowicz et al., 2015}}

\item{kernel_regularizer}{Regularizer function applied to the \code{kernel} weights
matrix.}

\item{recurrent_regularizer}{Regularizer function applied to the
\code{recurrent_kernel} weights matrix.}

\item{bias_regularizer}{Regularizer function applied to the bias vector.}

\item{activity_regularizer}{Regularizer function applied to.}

\item{kernel_constraint}{Constraint function applied to the \code{kernel} weights
matrix.}

\item{recurrent_constraint}{Constraint function applied to the \code{recurrent_kernel}
weights matrix.}

\item{bias_constraint}{Constraint function applied to the bias vector.}

\item{return_sequences}{Boolean. Whether to return the last output in the output
sequence, or the full sequence. (default FALSE)}

\item{return_state}{Boolean Whether to return the last state in addition to the
output. (default FALSE)}

\item{go_backwards}{Boolean (default FALSE). If TRUE, process the input sequence
backwards.}

\item{stateful}{Boolean (default FALSE). If TRUE, the last state for each sample
at index i in a batch will be used as initial state for the sample of
index i in the following batch.}

\item{dropout}{Float between 0 and 1. Fraction of the units to drop for the linear
transformation of the inputs.}

\item{recurrent_dropout}{Float between 0 and 1. Fraction of the units to drop for
the linear transformation of the recurrent state.}

\item{...}{standard layer arguments.}
}
\description{
1D Convolutional LSTM
}
\details{
Similar to an LSTM layer, but the input transformations
and recurrent transformations are both convolutional.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/ConvLSTM1D}
}
}
