% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{palette_size}
\alias{palette_size}
\alias{palette_size_sequential}
\alias{palette_size_diverging}
\title{Symbol Size Mapping}
\usage{
palette_size_sequential(range = c(1, 6), ...)

palette_size_diverging(range = c(1, 6), midpoint = 0, ...)
}
\arguments{
\item{range}{A length-two \code{\link{numeric}} vector giving range of possible sizes
(greater than 0).}

\item{...}{Currently not used.}

\item{midpoint}{A length-one \code{\link{numeric}} vector specifying the data mid-point.}
}
\value{
A palette \code{\link{function}} that when called with a single argument
(a \code{\link{numeric}} vector of continuous values) returns a \code{\link{numeric}} vector
giving the amount by which plotting text and symbols should be magnified
relative to the default.
}
\description{
Symbol Size Mapping
}
\examples{
## Visualize a simple DEM model
## Distribution of elevation values
elevation <- hist(volcano)

## Where are breaks?
elevation$breaks

## Build palette functions
BuRd <- color("BuRd")
ramp_BuRd <- palette_color_continuous(colors = BuRd(10))

## Plot image
image(volcano, col = ramp_BuRd(elevation$breaks))
legend("topright", legend = elevation$breaks, fill = ramp_BuRd(elevation$breaks))

## Scatter plot
## Build color palette functions
YlOrBr <- color("YlOrBr")
pal_color <- palette_color_continuous(colors = YlOrBr)

## Build symbol palette functions
pal_size <- palette_size_sequential(range = c(1, 3))

## Plot
plot(
  x = iris$Petal.Length,
  y = iris$Sepal.Length,
  pch = 16,
  col = pal_color(iris$Petal.Length),
  cex = pal_size(iris$Petal.Length),
  xlab = "Petal length",
  ylab = "Sepal length",
  panel.first = grid(),
  las = 1
)
}
\seealso{
Other palettes: 
\code{\link{palette_color_continuous}()},
\code{\link{palette_color_discrete}()},
\code{\link{palette_color_picker}()},
\code{\link{palette_shape}()}
}
\concept{palettes}
