% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{try_require}
\alias{try_require}
\title{Check if Specific Package is Installed}
\usage{
try_require(package, stop = TRUE, load = TRUE, lib.loc = NULL, ...)
}
\arguments{
\item{package}{Character. Name of the library}

\item{stop}{Boolean. Stop if not installed. If \code{FALSE} and
library is not available, warning will be shown.}

\item{load}{Boolean. Load library?}

\item{lib.loc}{Character vector. Location of R library trees
to search through, or \code{NULL}. The default value of \code{NULL}
corresponds to all libraries currently known to \code{.libPaths()}.
Non-existent library trees are silently ignored.}

\item{...}{Additional parameters.}
}
\value{
No return value, called for side effects.
}
\description{
This function checks library dependencies
}
\examples{
# Check if library base is installed. If not, stop and show error
try_require("base", stop = TRUE)
# Check if library xxx is installed. If not, show warning
try_require("xxx", stop = FALSE)
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{chr2num}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{dont_sleep}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{files_functions}()},
\code{\link{font_exists}()},
\code{\link{formatColoured}()},
\code{\link{formatHTML}()},
\code{\link{glued}()},
\code{\link{grepm}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{list_cats}()},
\code{\link{listfiles}()},
\code{\link{mail_send}()},
\code{\link{markdown2df}()},
\code{\link{move_files}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{updateLares}()},
\code{\link{warnifnot}()},
\code{\link{what_size}()}
}
\concept{Tools}
