% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main-prior_pred.R
\name{prior_pred}
\alias{prior_pred}
\alias{sample_param_prior}
\title{Prior (predictive) sampling}
\usage{
prior_pred(
  model,
  verbose = TRUE,
  quiet = FALSE,
  refresh = 0,
  STREAM = get_stream(),
  ...
)

sample_param_prior(model, verbose = TRUE, quiet = FALSE, ...)
}
\arguments{
\item{model}{An object of class \linkS4class{lgpmodel}.}

\item{verbose}{Should more information and a possible progress bar be
printed?}

\item{quiet}{This forces \code{verbose} to be \code{FALSE}. If you want
to suppress also the output from Stan, give the additional argument
\code{refresh=0}.}

\item{refresh}{Argument for \code{\link[rstan]{sampling}}.}

\item{STREAM}{External pointer. By default obtained with
\code{rstan::get_stream()}.}

\item{...}{Additional arguments for \code{\link[rstan]{sampling}}.}
}
\value{
\itemize{
  \item \code{prior_pred} returns a list with components
  \itemize{
     \item \code{y_draws}: A matrix containing the prior predictive draws
     as rows. Can be passed to \code{bayesplot::pp_check()} for
     graphical prior predictive checking.
     \item \code{pred_draws}: an object of class \linkS4class{Prediction},
     containing prior draws of each model component and their sum
     \item \code{param_draws}: a \code{stanfit} object of prior parameter
     draws (obtained by calling \code{sample_param_prior} internally)
   }
  \item \code{sample_param_prior} returns
  an object of class \code{\link[rstan]{stanfit}}
}
}
\description{
These functions take an \linkS4class{lgpmodel} object, and
\itemize{
  \item \code{prior_pred} samples from the prior predictive distribution of
  the model
  \item \code{sample_param_prior} samples only its parameter prior using
  \code{\link[rstan]{sampling}}
}
}
\seealso{
Other main functions: 
\code{\link{create_model}()},
\code{\link{draw_pred}()},
\code{\link{get_draws}()},
\code{\link{lgp}()},
\code{\link{pred}()},
\code{\link{sample_model}()}
}
\concept{main functions}
