% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zhipu_processor.R
\name{ZhipuProcessor}
\alias{ZhipuProcessor}
\title{Zhipu API Processor}
\description{
Zhipu API Processor

Zhipu API Processor
}
\details{
Concrete implementation of BaseAPIProcessor for Zhipu models.
Handles Zhipu-specific API calls, authentication, and response parsing.
}
\section{Super class}{
\code{mLLMCelltype::BaseAPIProcessor} -> \code{ZhipuProcessor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ZhipuProcessor-new}{\code{ZhipuProcessor$new()}}
\item \href{#method-ZhipuProcessor-get_default_api_url}{\code{ZhipuProcessor$get_default_api_url()}}
\item \href{#method-ZhipuProcessor-make_api_call}{\code{ZhipuProcessor$make_api_call()}}
\item \href{#method-ZhipuProcessor-extract_response_content}{\code{ZhipuProcessor$extract_response_content()}}
\item \href{#method-ZhipuProcessor-clone}{\code{ZhipuProcessor$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="get_api_url"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-get_api_url'><code>mLLMCelltype::BaseAPIProcessor$get_api_url()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="process_request"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-process_request'><code>mLLMCelltype::BaseAPIProcessor$process_request()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZhipuProcessor-new"></a>}}
\if{latex}{\out{\hypertarget{method-ZhipuProcessor-new}{}}}
\subsection{Method \code{new()}}{
Initialize Zhipu processor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZhipuProcessor$new(base_url = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_url}}{Optional custom base URL for Zhipu API}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZhipuProcessor-get_default_api_url"></a>}}
\if{latex}{\out{\hypertarget{method-ZhipuProcessor-get_default_api_url}{}}}
\subsection{Method \code{get_default_api_url()}}{
Get default Zhipu API URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZhipuProcessor$get_default_api_url()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Default Zhipu API endpoint URL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZhipuProcessor-make_api_call"></a>}}
\if{latex}{\out{\hypertarget{method-ZhipuProcessor-make_api_call}{}}}
\subsection{Method \code{make_api_call()}}{
Make API call to Zhipu
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZhipuProcessor$make_api_call(chunk_content, model, api_key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chunk_content}}{Content for this chunk}

\item{\code{model}}{Model identifier}

\item{\code{api_key}}{API key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
httr response object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZhipuProcessor-extract_response_content"></a>}}
\if{latex}{\out{\hypertarget{method-ZhipuProcessor-extract_response_content}{}}}
\subsection{Method \code{extract_response_content()}}{
Extract response content from Zhipu API response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZhipuProcessor$extract_response_content(response, model)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{response}}{httr response object}

\item{\code{model}}{Model identifier}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Extracted text content
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZhipuProcessor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ZhipuProcessor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZhipuProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
