% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examinee_updaters.R
\name{updateTest}
\alias{updateTest}
\title{Update the current test of an examinee object}
\usage{
updateTest(examinee_object, assessment_structure)
}
\arguments{
\item{examinee_object}{an \code{\linkS4class{examinee}} object.}

\item{assessment_structure}{an \code{\linkS4class{assessment_structure}} object.}
}
\value{
an \code{\linkS4class{examinee}} object with its \code{current_test} slot updated.
}
\description{
\code{\link{updateTest}} is the function for updating the new test ID in
an \code{\linkS4class{examinee}} object.
}
\examples{
## assessment uses two phases

examinee <- examinee_list_math[[1]]
examinee@current_test  ## T1
examinee@current_phase ## P1

examinee <- updateTest(examinee, assessment_structure_math)
examinee <- updatePhase(examinee, assessment_structure_math)
examinee@current_test  ## T1
examinee@current_phase ## P2

examinee <- updateTest(examinee, assessment_structure_math)
examinee <- updatePhase(examinee, assessment_structure_math)
examinee@current_test  ## T2
examinee@current_phase ## P1

}
