% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_mammalcol.R
\name{search_mammalcol}
\alias{search_mammalcol}
\title{Retrieve Data from the List of the Mammals of Colombia}
\usage{
search_mammalcol(splist, max_distance = 0.2)
}
\arguments{
\item{splist}{A character vector containing the names of the species to search for.}

\item{max_distance}{The maximum allowed distance for fuzzy matching of species names.
Defaults to 0.2.}
}
\value{
A data frame containing the retrieved information for each species.
}
\description{
This function takes a list of Mammal species names, searches for their data in
the MammalCol pacakage dataset, and returns a data frame containing the relevant
information for each species.
}
\details{
The function allows fuzzy matching for species names with a maximum
distance threshold to handle potential typos or variations in species names.
}
\examples{
library(mammalcol)

splist <- c("Tapirus bairdii", "Tapirus pinchaque", "Tapirus terrestris",
            "Tapirus terrestris", "tapir terrestre", "Pudu mephistophiles")

search_mammalcol(splist)


}
