% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portfolio.R
\name{portfolio}
\alias{portfolio}
\alias{write_portfolio}
\alias{read_portfolio}
\alias{portfolio_long}
\alias{portfolio_wide}
\title{Portfolio methods}
\usage{
write_portfolio(x, dsn, ...)

read_portfolio(src, ...)

portfolio_long(x, indicators = NULL, drop_geoms = FALSE)

portfolio_wide(x, indicators = NULL, drop_geoms = FALSE)
}
\arguments{
\item{x}{A portfolio object processed with \code{mapme.biodiversity}.}

\item{dsn}{A file path for the output file (must end with \code{gpkg}).}

\item{...}{Additional arguments supplied to \code{write_sf()} or \code{read_sf()}}

\item{src}{A character vector pointing to a GeoPackage that has been
previously written to disk via \code{write_portfolio()}}

\item{indicators}{If NULL (the default), all indicator columns will be detected
and transformed automatically. If a character vector is supplied, only
those indicators will be transformed.}

\item{drop_geoms}{A logical, indicating if geometries should be dropped.}
}
\value{
\code{write_portfolio()} returns \code{dsn}, invisibly.

\code{read_portfolio()} returns an \code{sf} object object with nested list
columns for every indicator found in the GeoPackage source file.

\code{portfolio_long()} returns the portfolio object in long-format.

\code{portfolio_wide()} returns the portfolio object in wide-format.
}
\description{
\code{write_portfolio()} writes a processed biodiversity portfolio to disk.
Portfolio data will only be serialized to disk as a GeoPackage including
two tables: \code{metadata} and \code{indicators}. The \code{metadata} tables
includes, among other simple variables the geometries and a primary
key called \code{assetid}. The 'indicators' tables includes the foreign key
\code{assetid}, a column called \code{indicator} giving the name of the original
indicator as well as the standard indicator columns \code{datetime}, \code{variable},
\code{unit}, and \code{value}. For convenience, use \code{read_portfolio()} to read
such a portfolio GeoPackage back into R.

\code{portfolio_long()} transforms a portfolio to long-format, potentially
dropping geometries in the process.

\code{portfolio_wide()} transforms a portfolio to wide-format, potentially
dropping geometries in the process.
}
