% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALO_opt.R
\name{ALO}
\alias{ALO}
\title{Ant Lion Optimizer}
\usage{
ALO(N, Max_iter, lb, ub, dim, fobj)
}
\arguments{
\item{N}{An integer indicate population size.}

\item{Max_iter}{An integer indicate maximum number of iterations.}

\item{lb}{A numeric vector that show lower bounds of the search space. One value per dimension.}

\item{ub}{A numeric vector that show upper bounds of the search space. One value per dimension.}

\item{dim}{An integer show the number of dimension (parameters) of the problem to optimize. It indicate the number of parameters to be optimized.}

\item{fobj}{An objective function used to be minimized. It is return single numeric value that show evaluation matrix result in every iteration.
It used to calculate the best fitness in every iteration.}
}
\value{
A list containing:
\describe{
  \item{best_fitness}{The best (minimum) fitness value found.}
  \item{best_position}{The parameter vector (position) corresponding to the best fitness.}
  \item{jml_iter}{The number of iterations executed.}
  \item{param}{Matrix of best parameters found across every iterations (dim × iter).}
  \item{param_list}{Vector of best fitness values at each iteration.}
}
}
\description{
An algorithm built by Mirjalili (2015) inspired by the hunting behaviour of antlion whose making pit trap for ant prey
in order to optimized real-valued objective function in continuous search space in a population-based manner.
}
\details{
The algorithm mimics the ALO hunting behaviour by simulating a stochastic search
where ants move around randomly under the influence of selected antlions and an elite antlion.

The algorithm performs until maximum iteration reached or convergence condition when the difference
in objective values for ten consecutive times is less than 10^-5.
}
\note{
The input vectors 'lb' and 'ub' must have the same length as the number of dimensions 'dim'.

This optimization function used inside svrHybrid function.
}
\examples{
{
sphere_fn <- function(x) sum(x^2) # simple function for objective function

# ALO optimization
set.seed(123)
result <- ALO(N = 20, Max_iter = 50, lb = c(-5,-5,-5), ub = c(5,5,5), dim = 3, fobj = sphere_fn)

# View best fitness and position found
result$best_fitness
result$best_position
}

}
\references{
Mirjalili, S. (2015). The Ant Lion Optimizer. Advances in Engineering Software, 83, 80-98.
https://doi.org/10.1016/j.advengsoft.2015.01.010.
}
