% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AOCBO_opt.R
\name{AOCBO}
\alias{AOCBO}
\title{Combined Archimedes Optimization with Coot Bird Optimization}
\usage{
AOCBO(N, Max_iter, lb, ub, dim, fobj)
}
\arguments{
\item{N}{An integer indicate population size.}

\item{Max_iter}{An integer indicate maximum number of iterations.}

\item{lb}{A numeric vector that show lower bounds of the search space. One value per dimension.}

\item{ub}{A numeric vector that show upper bounds of the search space. One value per dimension.}

\item{dim}{An integer show the number of dimension (parameters) of the problem to optimize. It indicate
the number of parameters to be optimized.}

\item{fobj}{An objective function used to be minimized. It is return single numeric value that show
evaluation matrix result in every iteration. It used to calculate the best fitness in every iteration.}
}
\value{
A list containing:
\describe{
  \item{best_fitness}{The best (minimum) fitness value found.}
  \item{best_position}{The parameter vector (position) corresponding to the best fitness.}
  \item{jml_iter}{The number of iterations executed.}
  \item{param}{Matrix of best parameters found across every iterations (dim × iter).}
  \item{param_list}{Vector of best fitness values at each iteration.}
}
}
\description{
A hybrid metaheuristic algorithm that combines Archimedes Optimization (AO) with
Coot Bird Optimization (CBO) to optimized real-valued objective function in continuous search space.
}
\details{
This metaheuristic implement combination of all step of Archimedes Optimization with first step used after initialization
is Coot Leader selection stage in CBO as early exploration step.
The hybrid design enhances convergence and stability in optimization step so it can maximize the best parameter.

The algorithm performs until maximum iteration reached or convergence condition when the difference in objective
values for ten consecutive times is less than 10^-5.
}
\note{
The input vectors `lb` and `ub` must have the same length as the number of dimensions `dim`.

This optimization function used inside svrHybrid function.
}
\examples{
{
sphere_fn <- function(x) sum(x^2) # simple function for objective function

# AOCBO optimization
set.seed(123)
result <- AOCBO(N = 20, Max_iter = 50, lb = c(-5,-5,-5), ub = c(5,5,5), dim = 3, fobj = sphere_fn)

# View best fitness and position found
result$best_fitness
result$best_position
}
}
