% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objective_function.R
\name{loss_calculate}
\alias{loss_calculate}
\title{Calculate Loss Based on Selected Objective Function}
\usage{
loss_calculate(preds, actuals, objective)
}
\arguments{
\item{preds}{A numeric vector of predicted values.}

\item{actuals}{A numeric vector of actual (true) values.}

\item{objective}{A string character that indicates the loss function type: "SMAPE", "MAPE", "RMSE", or "MAE".}
}
\value{
A numeric value that represent the computed loss.
}
\description{
Compute the loss between predictive and actual values using a selected objective function.
Supported objecive functions used in this functions are: "SMAPE', "MAPE", "RMSE", and "MAE".
}
\examples{
preds <- c(80, 120, 180)
actuals <- c(95, 115, 177)
loss_calculate(preds, actuals, "RMSE")

}
