% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.R
\name{scale_level}
\alias{scale_level}
\title{Scale intensities of features using level scaling}
\usage{
scale_level(data)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}
}
\value{
A tibble with level scaled intensities.
}
\description{
Scales the intensities of all features using

\deqn{\widetilde{x}_{ij}=\frac{x_{ij}-\overline{x}_{i}}{\overline{x}_{i}}}

where \eqn{\widetilde{x}_{ij}} is the intensity of sample \eqn{j}, feature \eqn{i} after scaling,
\eqn{x_{ij}} is the intensity of sample \eqn{j}, feature \eqn{i} before scaling and \eqn{\overline{x}_{i}} is the mean of intensities of feature \eqn{i} across all samples

In other words, it performs centering (\code{\link[metamorphr]{scale_center}}) and divides by the feature mean, thereby focusing on the relative intensity.
}
\examples{
toy_metaboscape \%>\%
  impute_lod() \%>\%
  scale_level()
}
\references{
\itemize{
\item R. A. Van Den Berg, H. C. Hoefsloot, J. A. Westerhuis, A. K. Smilde, M. J. Van Der Werf, \emph{BMC Genomics} \strong{2006}, \emph{7}, 142, DOI 10.1186/1471-2164-7-142.
}
}
