% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thselect.R
\name{thselect.cbm}
\alias{thselect.cbm}
\title{Threshold selection by shape mean square error minimization}
\usage{
thselect.cbm(xdat, thresh, B = 100)
}
\arguments{
\item{xdat}{vector of observations}

\item{thresh}{vector of thresholds}

\item{B}{number of bootstrap replications}
}
\value{
an object of class \code{mev_thselect_cbm} containing
\itemize{
\item{\code{thresh}: ordered vector of candidate thresholds}
\item{\code{thresh0}: selected threshold}
\item{\code{shape}: shape parameter coefficient estimates at each threshold}
\item{\code{nexc}: number of exceedances at each threshold}
\item{\code{bias}: vector of bootstrap bias estimates}
\item{\code{var}: vector of bootstrap variance estimates}
\item{\code{mse}: vector of mean squared error bootstrap estimates}
}
}
\description{
Use a semiparametric bootstrap to calculate the mean squared error
of the shape parameter using maximum likelihood for different thresholds, and return the one that minimize the mean squared error.
}
\examples{
set.seed(2025)
xdat <- rnorm(1000)
thresh <- qnorm(c(0.8, 0.9, 0.95))
thselect.cbm(xdat, thresh, B = 50)
}
\references{
Caers, J., Beirlant, J. and Maes, M.A. (1999). Statistics for Modeling Heavy Tailed Distributions in Geology: Part I. Methodology. \emph{Mathematical Geology}, 31, 391–410. <doi:10.1023/A:1007538624271>
}
