% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{qData}
\alias{qData}
\title{Extract of the abundances of Exp1_R25_pept dataset}
\format{
The format is: num [1:500, 1:6] 24.8 24.7 24.6 NA 24.5 ...  -
attr(*, "dimnames")=List of 2 ..$ : chr [1:500] "0" "1" "2" "3" ...  ..$ :
chr [1:6] "Intensity_C_R1" "Intensity_C_R2" "Intensity_C_R3"
"Intensity_D_R1" ...
}
\source{
The \code{DAPARdata} package.
}
\description{
The data frame \code{qData} contains the first 500 rows of six columns that are the quantitation of peptides for the six replicates. They were obtained using the code \code{exprs(Exp1_R25_pept)[1:500,]}.
}
\details{
The \code{DAPARdata}'s \code{Exp1_R25_pept} dataset is the final outcome of a quantitative mass spectrometry-based proteomic analysis of two samples containing different concentrations of 48 human proteins (UPS1 standard from Sigma-Aldrich) within a constant yeast background (see Giai Gianetto et al. (2016) for details). It contains the abundance values of the different human and yeast peptides identified and quantified in these two conditions. The two conditions represent the measured abundances of peptides when respectively 25 fmol and 10 fmol of UPS1 human proteins were mixed with the yeast extract before mass spectrometry analyses. This results in a concentration ratio of 2.5. Three technical replicates were acquired for each condition.
}
\examples{

data(qData)
str(qData)
pairs(qData)
 
}
\references{
Cox J., Hein M.Y., Luber C.A., Paron I., Nagaraj N., Mann M. Accurate proteome-wide label-free quantification by delayed normalization and maximal peptide ratio extraction, termed MaxLFQ. Mol Cell Proteomics. 2014 Sep, 13(9):2513-26.

Giai Gianetto, Q., Combes, F., Ramus, C., Bruley, C., Coute, Y., Burger, T. (2016). Calibration plot for proteomics: A graphical tool to visually check the assumptions underlying FDR control in quantitative experiments. Proteomics, 16(1), 29-32.
}
\keyword{datasets}
