% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_nest.R
\name{convert_nest}
\alias{convert_nest}
\title{Convert Nested Columns Between \code{data.frame} and \code{data.table}}
\usage{
convert_nest(data, to = c("df", "dt"))
}
\arguments{
\item{data}{A \code{data.frame} or \code{data.table} containing nested columns}

\item{to}{A \code{character} string specifying the target format.
Options are \code{"df"} (data frame) or \code{"dt"} (data table). Defaults to \code{"df"}.}
}
\value{
A transformed \code{data.frame} or \code{data.table} with all nested columns converted to the specified format.
If no nested columns are found, returns the original data with a warning.
}
\description{
The \code{convert_nest} function transforms a \code{data.frame} or \code{data.table} by converting nested columns
to either \code{data.frame} or \code{data.table} format while preserving the original data structure.
Nested columns are automatically detected based on list column identification.
}
\details{
Advanced Nested Column Conversion Features:
\itemize{
\item Intelligent automatic detection of all nested (list) columns
\item Comprehensive conversion of entire data structure
\item Non-destructive transformation with data copying
\item Seamless handling of mixed nested structures
}

Automatic Detection and Validation:
\itemize{
\item Automatically identifies all list columns in the dataset
\item Issues warning if no nested columns are detected
\item Returns original data unchanged when no list columns exist
\item Ensures data integrity through comprehensive checks
}

Conversion Strategies:
\enumerate{
\item Nested column identification based on \code{is.list()} detection
\item Preservation of original data integrity through copying
\item Flexible handling of mixed data structures
\item Consistent type conversion across all nested elements
}

Nested Column Handling:
\itemize{
\item Automatically processes all \code{list} columns
\item Handles \code{data.table}, \code{data.frame}, and generic \code{list} inputs
\item Maintains original column structure and order
\item Prevents in-place modification of source data
}
}
\note{
Conversion Characteristics:
\itemize{
\item Non-destructive transformation of all nested columns
\item Automatic detection eliminates need for manual column specification
\item Supports flexible input and output formats
\item Minimal performance overhead
}

Warning Conditions:
\itemize{
\item Issues warning if no list columns are found in the input data
\item Returns original data unchanged when no conversion is needed
\item Provides clear messages for troubleshooting
}
}
\examples{
# Example 1: Create nested data structures
# Create single nested column
df_nest1 <- iris |> 
  dplyr::group_nest(Species)     # Group and nest by Species

# Create multiple nested columns
df_nest2 <- iris |>
  dplyr::group_nest(Species) |>  # Group and nest by Species
  dplyr::mutate(
    data2 = purrr::map(          # Create second nested column
      data,
      dplyr::mutate, 
      c = 2
    )
  )

# Example 2: Convert nested structures
# Convert data frame to data table
convert_nest(
  df_nest1,                      # Input nested data frame
  to = "dt"                      # Convert to data.table
)

# Example 3: Convert data table to data frame
dt_nest <- mintyr::w2l_nest(
  data = iris,                   # Input dataset
  cols2l = 1:2                   # Columns to nest
)
convert_nest(
  dt_nest,                       # Input nested data table
  to = "df"                      # Convert to data frame
)
}
