% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Context.R
\name{Context}
\alias{Context}
\title{Context}
\description{
Context objects allow \link{Callback} objects to access and modify data.
The following packages implement context subclasses:
\itemize{
\item \code{ContextOptimization} in \CRANpkg{bbotk}.
\item \code{ContextEval} in \CRANpkg{mlr3tuning}.
\item \code{ContextTorch} in \href{https://github.com/mlr-org/mlr3torch}{\code{mlr3torch}}
}
}
\details{
\link{Context} is an abstract base class.
A subclass inherits from \link{Context}.
Data is stored in public fields.
Access to the data can be restricted with active bindings (see example).
}
\examples{
library(data.table)
library(R6)

# data table with column x an y
data = data.table(x = runif(10), y = sample(c("A", "B"), 10, replace = TRUE))

# context only allows to access column y
ContextExample = R6Class("ContextExample",
  inherit = Context,
  public = list(
    data = NULL,

    initialize = function(data) {
        self$data = data
    }
  ),

  active = list(
    y = function(rhs) {
      if (missing(rhs)) return(self$data$y)
      self$data$y = rhs
    }
  )
)

context = ContextExample$new(data)

# retrieve content of column y
context$y

# change content of column y to "C"
context$y = "C"
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the object.
Used in tables, plot and text output.}

\item{\code{label}}{(\code{character(1)})\cr
Label for this object.
Can be used in tables, plot and text output instead of the ID.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Context-new}{\code{Context$new()}}
\item \href{#method-Context-format}{\code{Context$format()}}
\item \href{#method-Context-print}{\code{Context$print()}}
\item \href{#method-Context-clone}{\code{Context$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Context-new"></a>}}
\if{latex}{\out{\hypertarget{method-Context-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Context$new(id, label = NA_character_)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{\code{label}}{(\code{character(1)})\cr
Label for the new instance.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Context-format"></a>}}
\if{latex}{\out{\hypertarget{method-Context-format}{}}}
\subsection{Method \code{format()}}{
Format object as simple string.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Context$format(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Context-print"></a>}}
\if{latex}{\out{\hypertarget{method-Context-print}{}}}
\subsection{Method \code{print()}}{
Print object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Context$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Context-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Context-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Context$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
